<?
    if (!isset($_SESSION)) session_start();
    // Verifica se não há a variável da sessão que identifica o usuário
    if (!isset($_SESSION['UserId'])) {
        // Destrói a sessão por segurança
        session_destroy();
        header("Location: ../index.php");
        exit;
    }
    $pg = $_GET['pg'];
    $sub1 = $_GET['sub1'];
    $sub2 = $_GET['sub2'];
    $sub3 = $_GET['sub3'];
    $sub4 = $_GET['sub4'];
    $sub5 = $_GET['sub5'];


    $server = $_SERVER['SERVER_NAME'];    
    $urlPrincipal = "http://".$server."/admin/admin/";
    require_once("includes/config.php");
    $timestamp = time();
?>
<!DOCTYPE html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <title>Administração - JS Engenharia</title>
        <meta name="author" content="http://www.periferica.me">
        <meta name="language" content="portuguese">
        <link rel="stylesheet" href="css/main.css">

        <!--[if IE]><link rel="shortcut icon" href="../../favicon.ico"><![endif]-->
        <link rel="icon" href="../../favicon.png">
        <link rel="apple-touch-icon" href="../../apple-touch-icon.png">

        <!-- SCRIPTS -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script>window.jQuery || document.write('<script src="<?=$urlPrincipal?>js/vendor/jquery-1.11.1.min.js"><\/script>')</script>

        <!-- UPLOADIFY -->       
        <script src="<?=$urlPrincipal?>upload/jquery.uploadifive.min.js" type="text/javascript"></script>
        <link rel="stylesheet" type="text/css" href="<?=$urlPrincipal?>upload/uploadifive.css">


        <!--[if lt IE 9]>
            <script type="text/javascript" src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
        <![endif]-->
    </head>
    <? flush(); ?>
    <body>
        <!--[if lt IE 9]>
            <script type="text/javascript" src="http://sawpf.com/1.0.js"></script>
        <![endif]-->  
        
        <!-- HEADER //-->
        <header class="header">
            <div class="wrapper">
                <a href="<?=$urlPrincipal?>" title="JS Engenharia" class="logo">
                    <img src="<?=$urlPrincipal?>img/logo-menor.png" alt="JS Engenharia">
                </a>
                <h1>Administração JS Engenharia</h1>
                <div class="nav_config">
                    <small><?=$_SESSION['UserNome']?></small><br>
                    <a href="<?=$urlPrincipal?>includes/logout.php" title="Sair do Sistema">Sair</a>
                </div><!-- nav_config -->
            </div><!-- wrapper -->
        </header><!-- header -->
        <!--// HEADER //-->

        <!-- NAV MAIN //-->
        <nav class="nav_main">
            <div class="wrapper">
                <ul>
                    <span></span>
                    <li><a href="<?=$urlPrincipal?>?pg=inicio" <? if($pg == "inicio") { ?> class="on" <? } ?> title="Inicio">Inicio</a></li><span></span>
                    <li><a href="<?=$urlPrincipal?>?pg=quem-somos&sub1=quem-somos" <? if($pg == "quem-somos") { ?> class="on" <? } ?> title="Quem Somos">Quem Somos</a></li><span></span>
                    <li><a href="<?=$urlPrincipal?>?pg=servicos&sub1=servicos" <? if($pg == "servicos") { ?> class="on" <? } ?> title="Serviços">Serviços</a></li><span></span>
                    <li><a href="<?=$urlPrincipal?>?pg=clientes&sub1=clientes" <? if($pg == "clientes") { ?> class="on" <? } ?> title="Clientes">Clientes</a></li><span></span>
                </ul>
            </div><!-- wrapper -->
        </nav><!-- nav_main -->
        <!--// NAV MAIN //-->

         <!-- CONTENT_MAIN //-->
        <article class="content_main">
            <div class="wrapper">
                <?
                $permitidos = array('inicio', 'servicos', 'quem-somos', 'clientes');
                // Verifica se a variável $_GET['pagina'] existe E se ela faz parte da lista de arquivos permitidos
                if (isset($_GET['pg']) AND (array_search($_GET['pg'], $permitidos) !== false)) {
                    switch ($pg){

                        case 'inicio':
                        include "inicio.php";
                        break;

                        case 'servicos':
                        include "servicos.php";
                        break;                       

                        case 'quem-somos':
                        include "quem-somos.php";
                        break;          
                        
                        case 'clientes':
                        include "clientes.php";
                        break; 

                        default:
                        include ("home.php");
                        break;
                    }
                } else {
                    include "home.php";
                }
                ?>
            </div><!-- wrapper -->  
        </article>
        <!--// CONTENT_MAIN //-->


        <div class="clear clearfix"></div>
        <!-- FOOTER_MAIN //-->
        <footer class="footer_main">
            <p>© Copyright <a href="//periferica.me" title="Periférica" target="_blank">Periférica</a> | Todos os Direitos Reservados.</p>
        </footer>
        <!--// FOOTER_MAIN //-->

        <!-- JQUERY UI - AUTOCOMPLETE + DATAPICKER -->
        <script src="<?=$urlPrincipal?>js/ui/jquery-ui-1.10.4.custom.min.js"></script>
        <link href="<?=$urlPrincipal?>js/ui/ui-lightness/jquery-ui-1.10.4.custom.css" rel="stylesheet">

        <!-- CKEDITOR -->
        <? /* ?><script src="<?=$urlPrincipal?>ckeditor/ckeditor.js"></script><? */ ?>
        <script src="//cdn.ckeditor.com/4.5.1/basic/ckeditor.js"></script>

        <!-- MASK CAMPOS FORM -->
        <script src="<?=$urlPrincipal?>js/jquery.mask.min.js"></script>

        <script type="text/javascript">
        $(function() {
            setTimeout(function () {

                $('#upload_fotos').uploadifive({
                    'formData'     : {
                        timestamp : '<?php echo $timestamp;?>',
                        pg : '<?php echo $sub1;?>',
                        menu : '<?php echo $menu;?>',
                        token     : '<?php echo md5('unique_salt' . $timestamp);?>'
                    },
                    'auto'             : true,
                    'checkScript'      : '<?=$urlPrincipal?>upload_html/check-exists.php',
                    'queueID'          : 'queue',
                    'uploadScript'     : '<?=$urlPrincipal?><?=$pg?>/uploadify.php',
                    'buttonText' : 'Adicionar Imagens',
                    'width'    : 200,
                    'fileTypeExts' : '*.jpg; *.png; *.jpeg',
                    'removeTimeout' : 1,
                    'fileSizeLimit': '15MB',
                    <? if($pg == "galeria") {?>
                    'queueSizeLimit' : 50,
                    'uploadLimit' : 50,
                    <? } else { ?>
                    'queueSizeLimit' : 50,
                    'uploadLimit' : 50,
                    <? } ?>
                    onUploadComplete : function(file) {
                        $("#carrega_fotos").load("<?=$pg?>/carrega_fotos.php?pg=<?=$pg?>&sub1=<?=$sub1?>&sub2=<?=$sub2?>&token=<?=$_GET['token']?>",function(responseTxt,statusTxt,xhr){
                        });
                    } 
                });      
            }, 0);

            /* DATAPICKER - JQUERY UI */
            $("#datepicker").datepicker({
                dateFormat: 'dd/mm/yy',
                dayNames: ['Domingo','Segunda','Terça','Quarta','Quinta','Sexta','Sábado'],
                dayNamesMin: ['D','S','T','Q','Q','S','S','D'],
                dayNamesShort: ['Dom','Seg','Ter','Qua','Qui','Sex','Sáb','Dom'],
                monthNames: ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
                monthNamesShort: ['Jan','Fev','Mar','Abr','Mai','Jun','Jul','Ago','Set','Out','Nov','Dez'],
                nextText: 'Próximo',
                prevText: 'Anterior'
            });

            $('#msg-fade').delay(1000).fadeIn();
            $('#msg-fade').delay(4000).fadeOut();

            CKEDITOR.replace( 'editor', {
                language: 'pt-br',
                height: 450,
                expand: true
            });            

        });
        </script>
    </body>
</html>
