<aside class="sidebar">
    <h1 class="titulo-padrao visible-desktop">Produtos</h1>
    <form action="<?php echo site_url(); ?>" class="busca">
        <input type="text" name="s" placeholder="Buscar produto" class="busca__input">
        <button class="busca__btn"><svg>
                <use xlink:href="<?php caminho_imagem('sprite.svg#icon-lupa'); ?>" />
            </svg></button>
    </form>
    <p class="sidebar__titulo visible-desktop">Linha de produtos</p>
    <button js-btn-sidebar class="sidebar__titulo sidebar__titulo--btn visible-mobile">Linha de produtos <svg>
            <use xlink:href="<?php caminho_imagem('sprite.svg#icon-seta'); ?>" />
        </svg></button>
    <ul js-menu-sidebar>
        <?php
        $linhas = get_terms('categoria');
        foreach ($linhas as $linha) {

            $filhos = get_terms(
                'categoria',
                array(
                    'hide_empty' => true,
                    'parent' => $linha->term_id
                )
            );

            if ($linha->parent == 0) {
                if (!empty($filhos)) {
                    $filhotes = get_term_children($linha->term_id, 'categoria');
                     ?>
                    <li>
                        <a href="#" js-sidebar-abrir-submenu><?php echo $linha->name; ?>
                            <svg>
                                <use xlink:href="<?php caminho_imagem('sprite.svg#icon-seta'); ?>" />
                            </svg>
                        </a>
                        <ul js-sidebar-submenu>
                            <?php
                            foreach ($filhotes as $filhote) {
                                $categoria = get_term_by('id', $filhote, 'categoria');
                                
                                if($categoria->parent != $linha->term_id){
                                    continue;
                                }
                            ?>
                                <li>
                                    <a href="<?php echo site_url('/categoria/' . $categoria->slug); ?>"><?php echo $categoria->name; ?></a>
                                    <?php
                                    $netos = get_term_children($categoria->term_id, 'categoria');
                                    if (!empty($netos)) { ?>
                                        <ul>
                                            <?php
                                            foreach ($netos as $neto) {
                                                $neto = get_term_by('id', $neto, 'categoria');
                                            ?>
                                                <li style="margin-left: 20px;">
                                                    <a href="<?php echo site_url('/categoria/' . $neto->slug); ?>"><?php echo $neto->name; ?></a>
                                                </li>
                                            <?php
                                            } // foreach netos 
                                            ?>
                                        </ul>
                                    <?php
                                    } // if !empty $netos 
                                    ?>
                                </li>
                            <?php
                            } // foreach filhotes 
                            ?>
                        </ul>
                    </li>
                <?php } else { ?>
                    <li>
                        <a href="<?php echo site_url('categoria/' . $linha->slug); ?>"><?php echo $linha->name; ?></a>
                    </li>
        <?php
                } // else filhos
            } // if parent
        } // foreach linha 
        ?>
    </ul>
</aside>