<?php

/* * ******** CONFIGURACOES ********* */
$svg_cache = 0;

/* * ******** INCLUDES ********* */

/* Inclui o function padrão Bravo - Necessário ACF */
include_once get_template_directory() . '/inc/_functions_bravo.php';

/* Incluir arquivos */
if (is_admin()) {
    include_once get_template_directory() . '/inc/email-contato.php';
    include_once get_template_directory() . '/inc/log-formularios.php';
}

add_filter('acf/settings/google_api_key', function () {
    return 'AIzaSyCH3N16oMKkkvF2P_Nqc30vnCt2nYLs9LQ';
});

/* * ******** ADICIONAR NO WP-CONFIG ********* */

// Desabilitar busca por atualizações do wordpress e plugins (deve ser colocado no wp-config);
//define("OTGS_DISABLE_AUTO_UPDATES", true);
// Desabilitar revisões
//define('WP_POST_REVISIONS', false );


/* * ******** FUNÇÕES EDITÁVEIS POR SITE ********* */

//PERSONALIZAR GALERIA DE IMAGENS
add_filter('post_gallery', 'custom_gallery', 10, 2);

function custom_gallery($output, $attr)
{
    $html = '<div class="gallery clearfix"><h4>Galeria de fotos</h4>' . "\n";
    $html .= '<ul>' . "\n";
    $att_ids = explode(',', $attr['ids']);
    foreach ($att_ids as $att_id) {
        $img = wp_get_attachment_image($att_id); //monta a tag img com a thumb
        if (empty($img))
            continue;
        $subtitle = get_thumbnail_subtitle($att_id);
        $href = get_thumbnail_url($att_id, 'large');
        $html .= '<li><a href="' . $href . '" title="' . $subtitle . '">' . $img . '</a></li>';
    }
    $html .= "</ul>\n";
    $html .= "</div>\n";
    return $html;
}

if (!function_exists('get_thumbnail_subtitle')) {

    function get_thumbnail_subtitle($thumb_id)
    {
        if (empty($thumb_id))
            $thumb_id = get_post_thumbnail_id();
        $attachment = get_post($thumb_id);
        if (empty($attachment))
            return '';
        return preg_replace('/\*([^*]+?)\*/', '<strong>$1</strong>', $attachment->post_excerpt);
    }
}

if (!function_exists('get_thumbnail_url')) {

    function get_thumbnail_url($thumb_id, $size = 'medium')
    {
        if (empty($thumb_id))
            $thumb_id = get_post_thumbnail_id();
        $image = image_downsize($thumb_id, $size);
        if (empty($image))
            return '';
        return $image[0];
    }
}

/* Wordpress SEO by Yoast função que chama as meta tags no header do plugin removendo os comentários chamar a função <?php seo_head(); ?> no header.php */
if (!function_exists('seo_head')) {

    function seo_head()
    {
        ob_start();
        do_action('wpseo_head');
        $content = ob_get_contents();
        ob_end_clean();
        echo preg_replace('/<!--(.*?)-->/', '', $content);
    }
}

function caminho_imagem($imagem)
{
    echo get_template_directory_uri() . "/images/$imagem";
}

function caminho_sprite($svg, $sprite = 'sprite')
{
    echo get_template_directory_uri() . "/images/{$sprite}.svg?1#{$svg}";
}

function carregar_imagem($campo, $tamanho = "large")
{
    echo get_field($campo)["sizes"][$tamanho] ?? caminho_imagem("placeholder.png");
}

function nome_mes($mes)
{
    $nome = array('Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro');
    return $nome[intval($mes - 1)];
}

function nome_dia_semana($dia)
{
    $diasemana = array('Domingo', 'Segunda-Feira', 'Terça-Feira', 'Quarta-Feira', 'Quinta-Feira', 'Sexta-Feira', 'Sabado');
    return $diasemana[intval($dia)];
}

function get_args($post_type, $posts_per_page = '')
{
    $categoria = get_queried_object();

    $args = array('post_type' => $post_type);

    $tax_query = array();

    if (is_tax() || is_category()) {
        $tax_query = array(
            'taxonomy' => $categoria->taxonomy,
            'field' => 'slug',
            'terms' => array($categoria->slug)
        );
    }

    if (!empty($posts_per_page)) {
        $args['posts_per_page'] = $posts_per_page;
    }

    if (!empty($tax_query)) {
        $args['tax_query'] = array($tax_query);
    }

    return $args;
}

$posts_listados = array();
function listar($args, $include, $pagination = true, $mensagem_sem_registro = 'Ops! Parece que não há nada aqui.')
{
    global $posts_listados;

    $pagina = (get_query_var('paged')) ? get_query_var('paged') : 1;

    if ($pagination) {
        $args['paged'] = $pagina;
    } else {
        $args['posts_per_page'] = -1;
    }

    if (!empty($posts_listados)) {
        $args['post__not_in'] = $posts_listados;
    }

    $consulta = new WP_Query($args);

    if ($consulta->have_posts()) {
        while ($consulta->have_posts()) {
            $consulta->the_post();
            $posts_listados[] = $consulta->post->ID;
            $post = get_post($consulta->post->ID);
            setup_postdata($post);
            include $include;
        }

        $base = '';

        $url = explode('/', $_SERVER['REQUEST_URI']);

        $base_inicio = 1;

        if ($_SERVER['HTTP_HOST'] == 'desenvolvimento.bravo.st' && $_SERVER['HTTP_HOST'] == 'dev.bravo.st') {
            $base_inicio = 3;
        }

        $base = $url[$base_inicio] . '/';

        for ($i = $base_inicio + 1; $i < count($url); $i++) {
            if ($url[$i][0] != '?' && $url[$i] != 'page') {
                $base = $base . '/' . $url[$i];
            } else {
                break;
            }
        }

        if ($pagination) {
            $paginas = paginate_links(array(
                "base"         => @add_query_arg('paged', '%#%'),
                "total"        => $consulta->max_num_pages,
                "current"      => max(1, get_query_var("paged")),
                "prev_next"    => false,
                "add_args"     => false,
                "add_fragment" => "",
                "add_args" => false,
            ));

            if (!empty($paginas)) :
                return '<div class="paginacao">' . $paginas . '</div>';
            endif;
        }
        wp_reset_postdata();
    } else {
        echo '<p class="erroBusca">' . $mensagem_sem_registro . '</p>';
    } // if have posts
}

function custom_field_excerpt($field_name, $excerpt_length = 20)
{
    global $post;
    $text = get_field($field_name); //Replace 'your_field_name'
    if ('' != $text) {
        $text = strip_shortcodes($text);
        $text = apply_filters('the_content', $text);
        $text = str_replace(']]&gt;', ']]&gt;', $text);
        $excerpt_more = apply_filters('excerpt_more', ' ' . '[...]');
        $text = wp_trim_words($text, $excerpt_length, $excerpt_more);
    }
    return apply_filters('the_excerpt', $text);
}

add_action('before_delete_post', 'before_delete_post');

function before_delete_post($post_id)
{
    global $wpdb;

    $child_atts = $wpdb->get_col("SELECT ID FROM {$wpdb->posts} WHERE post_parent = $post_id AND post_type = 'attachment'");

    foreach ($child_atts as $id)
        wp_delete_attachment($id);
}

function get_field_tax($field, $taxonomia)
{
    return get_field($field, $taxonomia->taxonomy . '_' . $taxonomia->term_id);
}

function descreve_array_itens($array)
{
    $ultimo = array_pop($array);
    return implode(', ', $array) . (!empty($array) ? ' e ' : '') . $ultimo;
}

add_action('wp_ajax_nopriv_upload', 'upload_ajax');
add_action('wp_ajax_upload', 'upload_ajax');

function upload_ajax()
{

    $uploadedfile = $_FILES[$_GET['name']];

    if (!empty($uploadedfile["tmp_name"])) {
        if (!function_exists('wp_handle_upload')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }

        $upload_overrides = array('test_form' => false);

        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);

        echo $movefile['url'];
    }

    echo '';

    exit;
}

add_action('wp_ajax_nopriv_limpar_midia', 'limpar_midia_ajax');
add_action('wp_ajax_limpar_midia', 'limpar_midia_ajax');
function limpar_midia_ajax()
{

    echo date('Y-m-d H:i:s') . '<br/>';

    set_time_limit(0);

    global $wpdb;

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    $campos = $wpdb->get_results("SELECT post_excerpt FROM {$wpdb->prefix}posts WHERE post_type = 'acf-field' AND (post_content like '%image%' OR post_content like '%gallery%' OR post_content like '%file%' OR post_content like '%wysiwyg%')", OBJECT);

    $likes = array();

    foreach ($campos as $campo) {
        $likes[] = "meta_key LIKE '%{$campo->post_excerpt}%'";
    }

    $likes = implode(' OR ', $likes);

    $sql = "SELECT
    meta_value
    FROM {$wpdb->prefix}postmeta
    WHERE
    $likes";

    $resultado = $wpdb->get_results($sql);

    $args = array(
        'post_type' => 'attachment',
        'numberposts' => -1,
        'fields' => 'ids'
    );

    $posts = get_posts($args);

    foreach ($posts as $id) {
        $apagar = true;

        foreach ($resultado as $valor) {
            if (strpos($valor->meta_value, $id . '') !== false) {
                $apagar = false;
                break;
            }
        }

        if ($apagar) {
            echo "apagar = $id<br/>";
            wp_delete_attachment($id);
        }
    }

    echo date('Y-m-d H:i:s') . '<br/>';

    exit;
}

function str_apenas_int($valor)
{
    return preg_replace("/\D/", "", $valor);
}

add_action('wp_ajax_nopriv_enviar_orcamento', 'enviar_orcamento_ajax');
add_action('wp_ajax_enviar_orcamento', 'enviar_orcamento_ajax');
function enviar_orcamento_ajax()
{

    $produtos = $_POST['produtos'];
    $cliente = $_POST['cliente'];

    ob_start();
?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">

    <body style="margin:0; padding:0; font-family: Verdana, Arial, sans-serif; font-size: 13px; color:#555;">
        <div style="width: 720px; margin: 40px auto;">

            <h1 style="margin-bottom:15px; text-align: center; text-transform: uppercase; font-weight: 800; font-size: 15px; letter-spacing: -0.05em;">Novo pedido de orçamento realizado pelo site</h1>

            <p style="text-align: center; font-size: 12px; margin-bottom:30px;"><?php echo date('d/m/Y'); ?></p>

            <div style="width: 100%; font-family: Verdana, Arial, sans-serif; font-size: 13px; letter-spacing: -0.03em; color:#555; border: 1px #c4c4c4 solid; border-radius: 5px; box-sizing: border-box;">
                <h2 style="background-color: #e1e1e1; font-size: 12px; line-height: 3.23em; font-weight: 600; color: #4b4b4b; padding: 0 25px; margin: 0 0 25px; box-sizing: border-box;">DADOS DO COMPRADOR</h2>

                <p style="display: block; margin: 0 0 4px; font-size: 13px; line-height: 1em; padding: 0 25px 0 32px;">Nome</p>
                <p style="margin: 0 0 20px; font-weight: 700; padding: 0 25px;"><?php echo $cliente['nome']; ?></p>

                <p style="display: block; margin: 0 0 4px; font-size: 13px; line-height: 1em; padding: 0 25px 0 32px;">E-mail</p>
                <p style="margin: 0 0 20px; font-weight: 700; padding: 0 25px;"><a href="mailto:<?php echo $cliente['email']; ?>"><?php echo $cliente['email']; ?></a></p>

                <p style="display: block; margin: 0 0 4px; font-size: 13px; line-height: 1em; padding: 0 25px 0 32px;">Telefone</p>
                <p style="margin: 0 0 20px; font-weight: 700; padding: 0 25px;"><?php echo $cliente['telefone']; ?></p>

                <p style="display: block; margin: 0 0 4px; font-size: 13px; line-height: 1em; padding: 0 25px 0 32px;">Cidade</p>
                <p style="margin: 0 0 20px; font-weight: 700; padding: 0 25px;"><?php echo $cliente['cidade']; ?></p>

                <p style="display: block; margin: 0 0 4px; font-size: 13px; line-height: 1em;  padding: 0 25px 0 32px;">Observações</p>
                <p style="margin: 0 0 20px; font-weight: 700; padding: 0 25px;"><?php echo $cliente['observacoes']; ?></p>
            </div>

            <table cellpadding="0" cellspacing="0" style="width:100%; font-family: Verdana, Arial, sans-serif; font-size: 13px; letter-spacing: -0.03em; margin-top: 30px; color:#555; border: 1px #c4c4c4 solid; border-radius: 5px;">
                <tr style="background-color: #e1e1e1; font-size: 12px; line-height: 3.23em; font-weight: 600; color: #4b4b4b;">
                    <th style="text-align: left; padding: 0 25px;">PRODUTO</th>
                    <th style="padding: 0 25px;">QTD</th>
                </tr>
                <?php
                foreach ($produtos as $produto) { ?>
                    <tr>
                        <td style="padding: 20px 25px 20px 25px; border-bottom: 1px #e1e1e1 solid;">
                            <p style="font-weight: 800; text-transform: uppercase; margin: 0 0 5px;"><?php echo $produto['titulo']; ?></p>
                        </td>
                        <td style="padding: 20px 25px 20px 25px;  border-bottom: 1px #e1e1e1 solid; text-align: center; font-weight: 800;"><?php echo $produto['quantidade']; ?></td>
                    </tr>
                <?php
                } // foreach $produtos 
                ?>
            </table>
        </div>
    </body>

    </html>
    <?php
    $message = ob_get_contents();
    ob_end_clean();

    $to = 'comercial@jsengenhariars.com.br';
    $subject = 'Orçamento através do site';
    $fromname = 'JS Engenharia e Segurança do Trabalho';
    $fromemail = 'comercial@jsengenhariars.com.br';

    $headers = array();
    $headers[] = 'From: "' . $fromname . '" <' . $fromemail . '>';
    $headers[] = 'Return-Path: <' . $fromemail . '>';
    $headers[] = 'Reply-To: "' . $cliente['nome'] . '" <' . $cliente['email'] . '>';
    $headers[] = 'X-Mailer: PHP' . phpversion();
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-Type: ' . get_bloginfo('html_type') . '; charset="' . get_bloginfo('charset') . '"';

    try {
        wp_mail($to, $subject, $message, $headers);
        echo "1";
        if (function_exists('log_contato')) {
            log_contato($fromemail, $to, $cliente['nome'], $cliente['email'], $subject, $message, 'orcamento');
        }
    } catch (Exception $e) {
        echo "Erro ao enviar. Tente novamente mais tarde.";
        mail('suporte@bravo.st', 'Erro em bravointerativa.com.br', print_r($e, true));
    }

    die();
}

function paginar(&$array, $parametros = array())
{

    $registros_por_pagina = 10;
    $paginas_navegacao = 2;

    if (!empty($parametros)) {
        if (!empty($parametros['registros_por_pagina'])) {
            $registros_por_pagina = $parametros['registros_por_pagina'];
        }

        if (!empty($parametros['paginas_navegacao'])) {
            $paginas_navegacao = $parametros['paginas_navegacao'];
        }
    }


    $total_registros = count($array);

    $pagina_atual = $_GET['pagina'] ?? 1;

    $array = array_slice($array, ($pagina_atual - 1) * $registros_por_pagina, $registros_por_pagina);

    $paginas_total = ceil($total_registros / $registros_por_pagina);

    $pontos_pre = false;
    $pontos_pos = false;

    ob_start();

    if ($paginas_total > 1) {
        for ($i = 0; $i < $paginas_total; $i++) {
            $pagina_item = $i + 1;

            if ($pagina_item == $pagina_atual) { ?>
                <span aria-current="page" class="page-numbers current"><?php echo $pagina_item ?></span>
                <?php } else if ($pagina_item < ($pagina_atual - $paginas_navegacao) && $pagina_item != 1) {
                if (!$pontos_pre) {
                    $pontos_pre = true;
                ?>
                    <span class="page-numbers dots">…</span>
                <?php } // if pontos_pos 
                ?>
                <?php } else if ($pagina_item > ($pagina_atual + $paginas_navegacao) && $pagina_item != $paginas_total) {
                if (!$pontos_pos) {
                    $pontos_pos = true;
                ?>
                    <span class="page-numbers dots">…</span>
                <?php
                }
                // if pontos_pos
            } else {
                $parametros_paginacao = implode('&', array_map(
                    function ($v, $k) {
                        return sprintf("%s=%s", $k, $v);
                    },
                    array_merge($_GET, array('pagina' => $pagina_item)),
                    array_keys(array_merge($_GET, array('pagina' => $pagina_item)))
                ));

                ?>
                <a class="page-numbers" href="<?php echo get_the_permalink() . '?' . $parametros_paginacao; ?>"><?php echo $pagina_item; ?></a>
<?php
            }
            // if pagina
        }
        // for
    }
    // if $paginas_total

    $retorno = ob_get_contents();
    ob_end_clean();

    return $retorno;
}

function svg($svg, $sprite = 'sprite')
{
    global $svg_cache;
    echo '<svg><use xlink:href="' . get_template_directory_uri() . "/images/$sprite.svg#" . $svg . '"?' . $svg_cache . ' /></svg>';
}

add_action('phpmailer_init', 'bravo_sparkpost');
function bravo_sparkpost($mail)
{
    $mail->SMTPDebug = 0;
    $mail->isSMTP();
    $mail->CharSet = 'UTF-8';
    $mail->Host = "smtp.sparkpostmail.com";
    $mail->SMTPAuth = true;
    $mail->Username = "SMTP_Injection";
    $mail->Password = "ad4520df575a94c09960cc7048ec8d908b98a373";
    $mail->SMTPSecure = "tls";
    $mail->Port = 2525;
}

/*function remove_menus(){

	if(!current_user_can('manage_options')) {
		remove_menu_page( 'index.php' ); //Dashboard
		remove_menu_page( 'edit.php' ); //Posts - imagens, vídeos, docs, etc...
		remove_menu_page( 'edit-comments.php' ); //Comments - comentários
		remove_menu_page( 'tools.php' ); //Tools - ferramentas (recomendo!)
	}
}

add_action( 'admin_menu', 'remove_menus' );*/

add_action('wp_ajax_nopriv_carregar_mais', 'carregar_mais_ajax');
add_action('wp_ajax_carregar_mais', 'carregar_mais_ajax');
function carregar_mais_ajax()
{

    $registros_por_pagina = $_POST['por_pagina'];

    $_POST['pagina'] = intval($_POST['pagina']);

    $args = get_args($_POST['post_type'], $registros_por_pagina);
    $args['offset'] = $_POST['pagina'] * $registros_por_pagina;

    ob_start();

    listar($args, "{$_POST['arquivo']}.php");

    $html = ob_get_contents();
    ob_end_clean();

    $args = get_args($_POST['post_type'], -1);
    $args['fields'] = 'ids';

    $posts = get_posts($args);

    echo json_encode(array('html' => $html, 'acabou' => ceil(count($posts) / $registros_por_pagina) - 1 == $_POST['pagina'], 'pagina' => ceil(count($posts) / $registros_por_pagina)));

    exit;
}

function tem_mais($post_type, $por_pagina)
{
    $args = get_args($post_type, -1);
    $args['fields'] = 'ids';

    $posts = get_posts($args);

    return count($posts) > $por_pagina;
}
