<!doctype html>
<html lang="pt-BR">

<head>
    <meta charset="utf-8">
    <title><?php wp_title(); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta http-equiv="Content-Language" content="pt-br">
    <meta name="language" content="portuguese, BR, PT">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, maximum-scale=1">
    <meta name="author" content="Bravo Interativa">
    <meta content="Bravo Interativa" property="og:author" />

    <?php
    seo_head();
    $imagem_share = get_template_directory_uri() . '/images/image-compartilhamento.png'; ?>
    <meta property="og:image" content="<?php echo $imagem_share; ?>" itemprop="image">
    <meta name="twitter:image" content="<?php echo $imagem_share; ?>" itemprop="image">
    <meta property="og:image:secure_url" content="<?php echo $imagem_share; ?>" />
    <meta property="og:image:type" content="png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="600">

    <meta name="msapplication-TileColor" content="#bf121d">
    <meta name="theme-color" content="#bf121d">

    <link rel="stylesheet" href="<?php echo get_file('style.css');   ?>">
    <link rel="shortcut icon" type="image/png" href="<?php echo get_file('images/favicon.png');   ?>" />

    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-1726512-123"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());

        gtag('config', 'UA-1726512-123');
    </script>

</head>

<body <?php body_class(); ?>>
    <input type="hidden" id="url_tema" value="<?php echo get_template_directory_uri(); ?>">
    <input type="hidden" id="url_ajax" value="<?php echo admin_url('admin-ajax.php'); ?>">
    <div class="grid <?php echo strpos(strtolower(getenv('HTTP_USER_AGENT')), 'mac') !== FALSE ? 'mac' : ''; ?>">
        <header class="header clearfix">
            <div class="container">
                <div class="header-box">
                    <div class="header-menu">
                        <a href="<?php echo site_url(); ?>" class="logo"><?php include 'images/logo-horizontal.svg' ?></a>
                        <nav js-menu class="menu">
                            <ul>
                                <li><a href="<?php echo site_url(); ?>" class="menu__link">Início</a></li>
                                <li><a href="<?php echo site_url('quem-somos'); ?>" class="menu__link">JS Engenharia</a></li>
                                <li><a href="<?php echo site_url('servicos'); ?>" class="menu__link">Serviços</a></li>
                                <li><a href="<?php echo site_url('produtos'); ?>" class="menu__link">Produtos</a></li>
                                <li><a href="<?php echo site_url('clientes'); ?>" class="menu__link">Clientes</a></li>
                                <li><a href="<?php echo site_url('contato'); ?>" class="menu__link">Contato</a></li>
                            </ul>
                        </nav>
                        <div js-toggle-menu class="toggle-menu visible-mobile">
                            <span class="tm1"></span>
                            <span class="tm2"></span>
                            <span class="tm3"></span>
                        </div>
                    </div>
                    <div class="header-infos">
                        <a href="<?php echo site_url('orcamento'); ?>" class="link-carrinho">
                            <svg>
                                <use xlink:href="<?php caminho_imagem('sprite.svg#icon-carrinho'); ?>" />
                            </svg>
                            <span><strong><i js-quantidade-carrinho>0 itens</i></strong> para orçar</span>
                        </a>
                    </div>
                </div>
            </div>
        </header>