<?php

/* Plugin Bravo - v0.76 */

$options_theme = get_transient('options_theme');

if(empty($options_theme)){

	$options_theme['file_edit'] = get_field('options_theme_file_edit', 'option');
	$options_theme['plugins_install'] = get_field('options_theme_plugins_install', 'option');
	$options_theme['hide_wp_generator'] = get_field('options_theme_hide_wp_generator', 'option');
	$options_theme['hide_core_updates'] = get_field('options_theme_hide_core_updates', 'option');
	$options_theme['images_sizes'] = get_field('options_theme_images_sizes', 'option');

	$options_theme['custom_post'] = get_field('options_theme_custom_post', 'option');
	$options_theme['taxonomy'] = get_field('options_theme_taxonomy', 'option');

	$options_theme['posts_thumbnails'] = get_field('options_theme_post_thumbnail', 'option');
	$options_theme['post_remove_original_image'] = get_field('options_theme_post_remove_original_image', 'option');
	$options_theme['post_remove_original_image_replace'] = get_field('options_theme_post_remove_original_image_replace', 'option');
	$options_theme['post_tags'] = get_field('options_theme_post_tags', 'option');
	$options_theme['post_metaboxes'] = get_field('options_theme_post_metaboxes', 'option');
	$options_theme['page_metaboxes'] = get_field('options_theme_page_metaboxes', 'option');

	$options_theme['post_custom_label'] = get_field('options_theme_post_custom_label', 'option');
	$options_theme['post_label_name'] = get_field('options_theme_post_label_name', 'option');
	$options_theme['post_label_singular_name'] = get_field('options_theme_post_label_singular_name', 'option');
	$options_theme['post_label_genre'] = get_field('options_theme_post_label_genre', 'option');

	/* Segurança */
	$options_theme['file_edit'] = get_field('options_theme_file_edit', 'option');
	$options_theme['plugins_install'] = get_field('options_theme_plugins_install', 'option');
	$options_theme['hide_wp_generator'] = get_field('options_theme_hide_wp_generator', 'option');
	$options_theme['hide_core_updates'] = get_field('options_theme_hide_core_updates', 'option');
	$options_theme['hide_plugins_updates'] = get_field('options_theme_hide_plugins_updates', 'option');
	$options_theme['hide_notices_updates'] = get_field('options_theme_hide_notices_updates', 'option');

	/* Tema */
	$options_theme['footer_panel_text'] = get_field('options_theme_footer_panel_text', 'option');
	$options_theme['admin_css'] = get_field('options_theme_admin_css', 'option');
	$options_theme['excerpt_length'] = get_field('options_theme_excerpt_length', 'option');
	$options_theme['excerpt_final'] = get_field('options_theme_excerpt_final', 'option', 'esc_attr');


	$options_theme['editor_hide_version'] = get_field('options_theme_editor_hide_version', 'option');




	set_transient('options_theme',$options_theme);
}

function clean_transient() {
    $screen = get_current_screen();
    if (strpos($screen->id, "bravo-settings") == true) {
      delete_transient('options_theme');
    }
}
add_action('acf/save_post', 'clean_transient', 20);



if( function_exists('acf_add_options_page') && current_user_can( 'manage_options' ) ) {
	acf_add_options_sub_page(array(
		'page_title' 	=> 'Configurações Bravo',
		'menu_title'	=> 'Configurações Bravo',
		'menu_slug' 	=> 'bravo-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false,
		'parent_slug' 	=> 'options-general.php',
	));
}

if(function_exists('acf_add_options_page')) {

	/* IMAGENS */

	/* Tamanhos de imagens */
	if(!empty($options_theme['images_sizes'])) {
	    foreach($options_theme['images_sizes'] as $row) {
	        add_image_size($row['options_theme_images_size_name'],$row['options_theme_images_size_width'],$row['options_theme_images_size_height'], $row['options_theme_images_size_crop']);
	    }
	}

	/* Imagens destacada nos posts */
	if( !empty($options_theme['posts_thumbnails']) && $options_theme['posts_thumbnails']){
		add_theme_support('post-thumbnails');
	}

	/* Remover imagem original */
	if( !empty($options_theme['post_remove_original_image']) && $options_theme['post_remove_original_image']){

		if(empty($options_theme['post_remove_original_image_replace'])){
			$options_theme['post_remove_original_image_replace'] = 'large';
		}

		add_action('wp_generate_attachment_metadata','brv_remove_original_attachment',10,2);
		function brv_remove_original_attachment($metadata,$att_id){
			global $options_theme;
			$max_size = $options_theme['post_remove_original_image_replace'];
			if(!empty($metadata['sizes'][$max_size]) && ($metadata['sizes'][$max_size]['width'] != $metadata['width'] || $metadata['sizes'][$max_size]['height'] != $metadata['height'])){
				rename(WP_CONTENT_DIR . '/uploads/'.$metadata['sizes'][$max_size]['file'], WP_CONTENT_DIR . '/uploads/'.$metadata['file']);
				$metadata['width'] = $metadata['sizes'][$max_size]['width'];
				$metadata['height'] = $metadata['sizes'][$max_size]['height'];
				unset($metadata['sizes'][$max_size]);
			}
			return $metadata;
		}
	}


	/* POSTS E PÁGINAS */


	/* Tags nos posts*/
	if( !empty($options_theme['post_tags']) && $options_theme['post_tags']){
		function myprefix_unregister_tags() {
			unregister_taxonomy_for_object_type('post_tag', 'post');
		}
		add_action('init', 'myprefix_unregister_tags');
	}

	/* Remove metaboxes dos posts */
	if( !empty($options_theme['post_metaboxes'])){
		function remove_default_post_screen_metaboxes() {
			global $options_theme;
			if(in_array('postcustom',$options_theme['post_metaboxes'])) remove_meta_box( 'postcustom','post','normal' ); // Custom Fields Metabox
			if(in_array('postexcerpt',$options_theme['post_metaboxes'])) remove_meta_box( 'postexcerpt','post','normal' ); // Excerpt Metabox
			if(in_array('commentstatusdiv',$options_theme['post_metaboxes'])) remove_meta_box( 'commentstatusdiv','post','normal' ); // Comments Metabox
			if(in_array('commentsdiv',$options_theme['post_metaboxes'])) remove_meta_box( 'commentsdiv','post','normal' ); // Comments Metabox
			if(in_array('trackbacksdiv',$options_theme['post_metaboxes'])) remove_meta_box( 'trackbacksdiv','post','normal' ); // Talkback Metabox
			if(in_array('slugdiv',$options_theme['post_metaboxes'])) remove_meta_box( 'slugdiv','post','normal' ); // Slug Metabox
			if(in_array('authordiv',$options_theme['post_metaboxes'])) remove_meta_box( 'authordiv','post','normal' ); // Author Metabox
			if(in_array('editor',$options_theme['post_metaboxes'])) remove_post_type_support( 'post','editor' ); // Wp-editor
		}
		add_action('admin_menu','remove_default_post_screen_metaboxes');
	}

	/* Remove metaboxes das páginas */
	if( !empty($options_theme['page_metaboxes'])){
		function remove_default_page_screen_metaboxes() {
			global $options_theme;
			if(in_array('postcustom',$options_theme['page_metaboxes'])) remove_meta_box( 'postcustom','page','normal' ); // Custom Fields Metabox
			if(in_array('commentstatusdiv',$options_theme['page_metaboxes'])) remove_meta_box( 'commentstatusdiv','page','normal' ); // Comments Metabox
			if(in_array('commentsdiv',$options_theme['page_metaboxes'])) remove_meta_box( 'commentsdiv','page','normal' ); // Comments Metabox
			if(in_array('slugdiv',$options_theme['page_metaboxes'])) remove_meta_box( 'slugdiv','page','normal' ); // Slug Metabox
			if(in_array('authordiv',$options_theme['page_metaboxes'])) remove_meta_box( 'authordiv','page','normal' ); // Author Metabox
			if(in_array('editor',$options_theme['page_metaboxes'])) remove_post_type_support( 'page','editor' ); // Wp-editor
		}
		add_action('admin_menu','remove_default_page_screen_metaboxes');
	}

	/* Tipos de posts */

	if(!empty($options_theme['custom_post'])) {
	    foreach($options_theme['custom_post'] as $row) {

	    	$cpt = array(
	    		'slug' => $row['options_theme_custom_post_slug'],
	    		'name' => $row['options_theme_custom_post_name'],
	    		'singular_name' => $row['options_theme_custom_post_singular_name'],
	    		'genre' => $row['options_theme_custom_post_genre'],
	    		'position' => $row['options_theme_custom_post_position'],
	    		'icon' => $row['options_theme_custom_post_icon'],
	    		'hierarchical' => $row['options_theme_custom_post_hierarchical'],
	    		);

	    	$supports = array();
	    	if(!empty($row['options_theme_custom_post_supports'])) {
	    		$supports = $row['options_theme_custom_post_supports'];
	    	}

				register_post_type( $cpt['slug'], array(
					'labels' => array('name' => $cpt['name'], 'singular_name' => $cpt['singular_name'], 'add_new'=>'Adicionar '.($cpt['genre']=='f'?'nova ':'novo '), 'add_new_item'=>'Adicionar '.($cpt['genre']=='f'?'nova ':'novo ').strtolower($cpt['singular_name']), 'edit_item'=>'Editar '.strtolower($cpt['singular_name']), 'view_item'=>'Ver '.strtolower($cpt['singular_name']), 'search_items'=> 'Pesquisar '.strtolower($cpt['name']), 'not_found'=>($cpt['genre']=='f'?'Nenhuma ':'Nenhum ').strtolower($cpt['singular_name']).($cpt['genre']=='f'?' encontrada':' encontrado'), 'not_found_in_trash'=>($cpt['genre']=='f'?'Nenhuma ':'Nenhum ').strtolower($cpt['singular_name']).($cpt['genre']=='f'?' encontrada':' encontrado').' na lixeira', ),
					'public' => true,
					'has_archive' => true,
					'menu_position' => intval($cpt['position']),
			    'menu_icon' => $cpt['icon'],
			    'supports' => array('title','editor','thumbnail'),
			    'hierarchical' => $cpt['hierarchical'],
			    'supports' => $supports
			    //'taxonomies' => array('category'),
			    //'exclude_from_search' => false,
			    ));
	    }
	}

	/* Taxonomias para mais de um tipo de post */
	if(!empty($options_theme['taxonomy'])) {
	    foreach ( $options_theme['taxonomy'] as $row ) {

  			$taxonomy = array(
					'slug' => $row['options_theme_taxonomy_slug'],
					'name' => $row['options_theme_taxonomy_name'],
					'singular_name' => $row['options_theme_taxonomy_singular_name'],
					'genre'=> $row['options_theme_taxonomy_genre'],
					'hierarchical'=> $row['options_theme_taxonomy_hierarchical'],
					'show_admin_column'=> $row['options_theme_taxonomy_show_admin_column'],
					'meta_box_cb'=> $row['options_theme_taxonomy_meta_box_cb'],
				);

					$object_type = array();
					if(!empty($row['options_theme_taxonomy_types'])){
						foreach($row['options_theme_taxonomy_types'] as $options_theme_taxonomy_type){
							$object_type[] = $options_theme_taxonomy_type['options_theme_taxonomy_types_slug'];
						}
						$taxonomy['object_type'] = $object_type;
					}

			  register_taxonomy( $taxonomy['slug'], $taxonomy['object_type'], array(
			    'labels' => array('name' => $taxonomy['name'], 'singular_name' => $taxonomy['singular_name'], 'edit_item'=>'Editar '.strtolower($taxonomy['singular_name']), 'add_new_item'=>'Adicionar '.($taxonomy['genre']=='f'?'nova ':'novo ').strtolower($taxonomy['singular_name']), ),
			    'hierarchical' => $taxonomy['hierarchical'],
			    'show_admin_column' => $taxonomy['show_admin_column'],
			    'meta_box_cb' => ($taxonomy['meta_box_cb'] == true) ? null : false,
			  ));

	    }
	}

	if( !empty($options_theme['post_custom_label']) && $options_theme['post_custom_label']){

		$labels = array(
			'name' => $options_theme['post_label_name'],
			'singular_name' => $options_theme['post_label_singular_name'],
			'genre'=> $options_theme['post_label_genre'],
		);

		function change_post_menu_label() {
			global $menu,$submenu, $labels;
			$menu[5][0] = $labels['name'];
			$submenu['edit.php'][5][0] = $labels['name'];
			$submenu['edit.php'][10][0] = 'Adicionar '.($labels['genre']=='f'?'nova ':'novo ');
		}
		add_action( 'admin_menu', 'change_post_menu_label' );

		function change_post_object_label() {
			global $wp_taxonomies, $wp_post_types, $labels;
			$wp_post_types['post']->labels->name = $labels['name'];
			$wp_post_types['post']->labels->singular_name = $labels['singular_name'];
			$wp_post_types['post']->labels->add_new = 'Adicionar nova';
			$wp_post_types['post']->labels->add_new_item = 'Adicionar '.($labels['genre']=='f'?'nova ':'novo ').strtolower($labels['singular_name']);
			$wp_post_types['post']->labels->edit_item = 'Editar '.strtolower($labels['singular_name']);
			$wp_post_types['post']->labels->new_item = ($labels['genre']=='f'?'Nova ':'Novo ').strtolower($labels['singular_name']);
			$wp_post_types['post']->labels->view_item = 'Ver '.strtolower($labels['singular_name']);
			$wp_post_types['post']->labels->search_items = 'Pesquisar '.strtolower($labels['name']);
			$wp_post_types['post']->labels->not_found = ($labels['genre']=='f'?'Nenhuma ':'Nenhum ').strtolower($labels['singular_name']).' encontrada.';
			$wp_post_types['post']->labels->not_found_in_trash = ($labels['genre']=='f'?'Nenhuma ':'Nenhum ').strtolower($labels['singular_name']).' encontrada na lixeira.';
			$wp_post_types['post']->labels->all_items = ($labels['genre']=='f'?'Todas as ':'Todos os ').strtolower($labels['name']);
			$wp_post_types['post']->labels->menu_name = $labels['name'];
			$wp_post_types['post']->labels->name_admin_bar = $labels['singular_name'];
		}
		add_action( 'init', 'change_post_object_label' );

	}

	/* SEGURANÇA */

	/* Desabilitar edição de arquivos pelo painel */
	if( !empty($options_theme['file_edit']) && $options_theme['file_edit']){
		define('DISALLOW_FILE_EDIT', true);
	}

	/* Força a instalação de plugins */
	if( !empty($options_theme['plugins_install']) && $options_theme['plugins_install']){
		define('FS_METHOD','direct');
	}

	/* Remove a versão do php do header */
	if( !empty($options_theme['hide_wp_generator']) && $options_theme['hide_wp_generator']){
		remove_action('wp_head', 'wp_generator');
	}

	/* Esconde atualizações do WordPress */
	if( !empty($options_theme['hide_core_updates']) && $options_theme['hide_core_updates']){
		add_action('after_setup_theme','remove_core_updates');
		function remove_core_updates() {
			if(! current_user_can('update_core')){return;}
			add_action('init', create_function('$a',"remove_action( 'init', 'wp_version_check' );"),2);
			add_filter('pre_option_update_core','__return_null');
			add_filter('pre_site_transient_update_core','__return_null');
		}
	}

	/* Esconde atualizações de plugins */
	if( !empty($options_theme['hide_plugins_updates']) && $options_theme['hide_plugins_updates']){
		global $user_login;
		get_currentuserinfo();
		if (!current_user_can('update_plugins')) { // checks to see if current user can update plugins
			add_action( 'init', create_function( '$a', "remove_action( 'init', 'wp_version_check' );" ), 2 );
			add_filter( 'pre_option_update_core', create_function( '$a', "return null;" ) );
		}
	}

	/* Esconde notificações de atualizações */
	if( !empty($options_theme['hide_notices_updates']) && $options_theme['hide_notices_updates']){
		function hide_update_notice() {
	    get_currentuserinfo();
	    if (!current_user_can('manage_options')) {
	        remove_action( 'admin_notices', 'update_nag', 3 );
	    }
		}
		add_action( 'admin_notices', 'hide_update_notice', 1 );
	}


	/* TEMA */

	/* Desabilitar edição de arquivos pelo painel */
	if( !empty($options_theme['footer_panel_text'])){
		function custom_admin_footer() {
			global $options_theme;
			echo $options_theme['footer_panel_text'];
		}
		add_filter('admin_footer_text', 'custom_admin_footer');
	}

	/* Limitar resumo por quantidade de palavras */
	if( !empty($options_theme['excerpt_length'])){
		function custom_excerpt_length($length) {
			global $options_theme;
			return $options_theme['excerpt_length'];
		}
		add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );
	}

	/* Alterar caracteres do final do resumo */
	if( !empty($options_theme['excerpt_final'])){
		function new_excerpt_more( $more ) {
			global $options_theme;
			return esc_html($options_theme['excerpt_final']);
		}
		add_filter( 'excerpt_more', 'new_excerpt_more' );
	}

}

// Logotipo no login
add_action( 'login_head', 'wp_custom_login');
function wp_custom_login() {
	echo '<style type="text/css">h1 a { background-image:url("http://www.bravo.st/images/wpadmin.png") !important; margin-bottom: 10px; padding: 20px; background-size: 200px 20px!important; width:200px!important; height:20px!important;}</style>';
}

function get_current_taxonomy($taxonomy){
	global $post;
	$tax = wp_get_post_terms($post->ID, $taxonomy);
	return $tax[0]->name;
}

function the_current_taxonomy($taxonomy){
	global $post;
	$tax = wp_get_post_terms($post->ID, $taxonomy);
	echo $tax[0]->name;
}

function get_file($filename){
	if(file_exists(get_template_directory().'/'.$filename)) {
		$time = filemtime(get_template_directory().'/'.$filename);
		$file_url = get_template_directory_uri().'/'.$filename.'?v='.$time;
		return $file_url;
	}
}

/* Alterar CSS do painel para usuários não administradores */
if(!empty($options_theme['admin_css'])) {
	add_action('admin_head', 'custom_admin_css');
	function custom_admin_css() {
	  if (!current_user_can('manage_options')) {
			global $options_theme;
			echo '<style type="text/css">'.$options_theme['admin_css'].'</style>';
		}
	}
}

/* Esconde a versão do Wordpress para usuários não administradores */
if(!empty($options_theme['editor_hide_version']) && $options_theme['editor_hide_version']) {
	function editor_hide_version() {
	    if (!current_user_can('manage_options')) {
	      remove_filter( 'update_footer', 'core_update_footer' );
	    }
	}
	add_action( 'admin_menu', 'editor_hide_version' );
}