<?php

$forms = array(
	'contact' => 'Formulário de contato',
	'newsletter' => 'Newsletter',
	'orcamento' => 'Orçamento',
);

foreach ($forms as $key => $form) {
	add_action('wp_ajax_nopriv_' . $key, 'contact_ajax');
	add_action('wp_ajax_' . $key, 'contact_ajax');
}

function contact_ajax()
{

	$post_data = $_POST;
	if (empty($post_data)) die();

	// Evitar spam
	if (!empty($post_data['trap'])) die();

	if ($post_data['action'] == 'contact') {

		$fields = array(
			'nome' => 'Nome',
			'email' => 'E-mail',
			'telefone' => 'Telefone',
			'cidade' => 'Cidade',
			'mensagem' => 'Mensagem',
		);
		$required = array('nome', 'email', 'mensagem');
		$text = 'Mensagem enviada através do site:';
		$subject = 'Contato através do site';
		$to = 'comercial@jsengenhariars.com.br';
	} else if ($post_data['action'] == 'newsletter') {
		$fields = array(
			'nome' => 'Nome',
			'email' => 'E-mail',
		);
		$required = array('nome', 'email');
		$text = 'E-mail cadastrado:';
		$subject = 'Cadastro na newsletter do site';
		$to = 'suporte@bravo.st';
		confirmacao($post_data['action'], $post_data['email'], $post_data['nome']);
	}


	$errors = array();
	if (!empty($required)) foreach ($required as $field) {
		if (empty($post_data[$field])) $errors[$field] = 'O campo ' . $fields[$field] . ' deve ser preenchido';
	}
	if (!empty($post_data['email']) && !filter_var($post_data['email'], FILTER_VALIDATE_EMAIL)) $errors['email'] = 'E-mail inválido';

	if (!empty($errors)) die('Erro: ' . implode('<br/>', $errors));

	$post_data['email'] = strtolower($post_data['email']);
	$post_data['mensagem'] = nl2br($post_data['mensagem']); //troca "enter" por <br>

	ob_start();
?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">

	<head>
		<title></title>
	</head>

	<body style="margin:0; padding:0; font-family: Verdana, Arial, sans-serif; font-size: 13px; color:#555;">
		<p style="margin-bottom:10px;"><?php echo $text; ?></p>
		<table cellpadding="0" cellspacing="0" style="width:720px; margin: 10px 0 0 0; font-family: Verdana, Arial, sans-serif; font-size: 13px; color:#555; background-color:#f0f0f0;">
			<?php foreach ($fields as $field => $name) : ?>
				<tr style="vertical-align:top">
					<td style="padding: 5px 10px; border-bottom:1px dotted #ddd; color:#888; width:100px;"><?php echo $name; ?></td>
					<td style="padding: 5px 10px; border-bottom:1px dotted #ddd; color:#333;"><?php echo $post_data[$field]; ?></td>
				</tr>
			<?php endforeach; ?>
		</table>
	</body>

	</html>
	<?php
	$message = ob_get_contents();
	ob_end_clean();

	$subject = $subject;
	$fromname = 'JS Engenharia';
	$fromemail = 'comercial@jsengenhariars.com.br';

	$headers = array();
	$headers[] = 'From: "' . $fromname . '" <' . $fromemail . '>';
	$headers[] = 'Return-Path: <' . $fromemail . '>';
	$headers[] = 'Reply-To: "' . $post_data['nome'] . '" <' . $post_data['email'] . '>';
	$headers[] = 'X-Mailer: PHP' . phpversion();
	$headers[] = 'MIME-Version: 1.0';
	$headers[] = 'Content-Type: ' . get_bloginfo('html_type') . '; charset="' . get_bloginfo('charset') . '"';

	try {
		wp_mail($to, $subject, $message, $headers);
		echo "1";
		if (function_exists('log_contato')) {
			log_contato($fromemail, $to, $post_data['nome'], $post_data['email'], $subject, $message, $post_data['action']);
		}
	} catch (Exception $e) {
		echo "Erro ao enviar. Tente novamente mais tarde.";
		mail('suporte@bravo.st', 'Erro em bravointerativa.com.br', print_r($e, true));
	}

	die();
}

function confirmacao($action, $to, $nome)
{
	$subject = 'Bravo Interativa';
	$fromname = 'Bravo Interativa';
	$fromemail = 'suporte@bravo.st';

	ob_start();
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">

	<head>
		<title></title>
	</head>

	<body style="margin:0; padding:0; font-family: Verdana, Arial, sans-serif; font-size: 13px; color:#000;">
		<p style="margin-bottom:10px;"><?php echo $text; ?></p>
		<table cellpadding="0" cellspacing="0" style="width:720px; margin: 10px 0 0 0; font-family: Verdana, Arial, sans-serif; font-size: 13px; color:#000;">
			<?php if ($action == "contact") { ?>
				<p style="margin-bottom:50px; padding-left:20px;">Olá <strong><?php echo $nome; ?></strong>,<br>
					Recebemos sua mensagem!</p>
				<p style="font-style:italic; font-size:12px;">Está é uma mensagem automática, favor não responder.</p>
			<?php } // (if) se for contato 
			?>
		</table>
	</body>

	</html>
<?php
	$message = ob_get_contents();
	ob_end_clean();

	$headers = array();
	$headers[] = 'From: "' . $fromname . '" <' . $fromemail . '>';
	$headers[] = 'Return-Path: <' . $fromemail . '>';
	$headers[] = 'Reply-To: "' . $fromname . '" <' . $fromemail . '>';
	$headers[] = 'X-Mailer: PHP' . phpversion();
	$headers[] = 'MIME-Version: 1.0';
	$headers[] = 'Content-Type: ' . get_bloginfo('html_type') . '; charset="' . get_bloginfo('charset') . '"';

	try {
		wp_mail($to, $subject, $message, $headers);
	} catch (Exception $e) {
		mail('suporte@bravo.st', 'Erro em bravo.st', print_r($e, true));
	}
}
