$(function () {
    /******************START FUNÇÕES******************/

    //tamanhoImagens();
    //tamanhoMenu();
    //getEndereco();
    $(window).resize(function () {
        //tamanhoImagens();
        //tamanhoMenu();
    });

    /********************COMPORTAMENTO******************/

    atualizarQuantidade();

    let carrinho = buscarCarrinho();

    if(carrinho.length > 0){

        $('[js-sem-itens]').hide();
        $('[js-com-itens]').show();
        let html = '';
        $.each(carrinho, function(){
            html += `<tr class="tabela-orcamento__prod" js-codigo="${this.codigo}">
            <td class="tabela-orcamento__img">`;
            if(this.imagem.split("/")[this.imagem.split("/").length - 1] != 'placeholder.jpg'){
                html += `<a href="${this.imagem}" data-fancybox title="Ver foto do produto">
                <img src="${this.imagem}" alt="${this.titulo}">
                </a>`
            } else {
                html += `<div>
                <img src="${this.imagem}" alt="${this.titulo}">
                </div>`
            }

            html += `</td>
            <td class="tabela-orcamento__infos">
            <a href="${this.link}" title="Ver detalhes do produto">
            <p class="produtos-item__titulo">${this.titulo}</p>`;

            html += `</a>
            </td>
            <td class="tabela-orcamento__qtd">
            <div class="qtd">
            <button class="qtd__btn qtd__btn--menos" js-qtd-menos><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 455 455">
            <polyline fill="var(--cor-vertical)" points="212 0 212 455 243 455 243 0"/>
            <polyline points="0 243 455 243 455 212 0 212"/>
            </svg>
            </button>
            <input class="qtd__campo" type="text" id="quantidade" name="quantidade" value="${this.quantidade}" readonly js-qtd-campo>
            <button class="qtd__btn" js-qtd-mais><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 455 455">
            <polyline points="212 0 212 455 243 455 243 0"/>
            <polyline points="0 243 455 243 455 212 0 212"/>
            </svg>
            </button>
            </div>
            </td>
            <td class="tabela-orcamento__btn-excluir">
            <button js-excluir-produto>
            <svg xmlns="http://www.w3.oeg/2000/svg" viewBox="0 0 512 512">
            <path d="M256,0C114.84,0,0,114.84,0,256S114.84,512,256,512,512,397.16,512,256,397.16,0,256,0Z"/>
            <path fill="#fafafa" d="M350.27,320.11a21.33,21.33,0,1,1-30.16,30.16L256,286.16l-64.11,64.11a21.33,21.33,0,0,1-30.16-30.16L225.84,256l-64.11-64.11a21.33,21.33,0,0,1,30.16-30.16L256,225.84l64.11-64.11a21.33,21.33,0,0,1,30.16,30.16L286.16,256Z"/>
            </svg>
            <span>excluir</span>
            </button>
            </td>
            </tr>`

            let lista = $(`button[js-codigo="${this.codigo}"]`);
            lista.find('[js-adicionado]').hide();
            lista.find('[js-removido]').show();
        });

        $('[js-carrinho]').append(html);
    } else {
        $('[js-com-itens]').hide();
        $('[js-sem-itens]').show();
        $('[js-finalizar-orcamento]').hide();
    }

    // Toggle Menu
    $('[js-toggle-menu]').click(function (e) {
        e.preventDefault();
        e.stopPropagation();
        $('[js-menu]').toggleClass('active');
        $('body').toggleClass('noscroll');

        if ($('[js-sub-menu] > ul.active').length > 0) {
            $('[js-sub-menu] > ul').removeClass('active');
        }
    });

    $('[js-sub-menu] > a').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).siblings('ul').addClass('active');
    });

    $('[js-sub-menu] > ul .voltar').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).closest('ul').removeClass('active');
    });

    $('body, html').click(function () {
        $('[js-menu]').removeClass('active');
    });

    /* função para abrir o bloco de compartilhamento nativo */
    btnCompartilhar = $('[js-btn-compartilhar]');
    tituloCompartilhar = btnCompartilhar.data('titulo');
    legendaCompartilhar = btnCompartilhar.data('legenda');
    urlCompartilhar = btnCompartilhar.data('url');

    let shareData = {
        title: tituloCompartilhar,
        text: legendaCompartilhar,
        url: urlCompartilhar,
    }

    btnCompartilhar.on('click', function (e) {
        e.preventDefault();
        navigator.share(shareData);
    });

    // Voltar a página
    $("[js-voltar]").click(function (e) {
        e.preventDefault();
        history.go(-1);
    });

    // Voltar para o topo
    $('[js-ancora-topo]').click(function (e) {
        e.preventDefault();
        $("html, body").animate({ scrollTop: 0 }, 600);
    });

    // Scroll âncora suave
    $('[js-ancora-suave]').click(function (e) {
        e.preventDefault();
        $("html, body").animate({ scrollTop: $($(this).attr('href')).offset().top }, 600);
    });

    //estilização do input-file
    $('[type="file"]').change(function (e) {
        var elemento = $(this);
        elemento.prev().html(e.target.files[0].name);
        elemento.parent().addClass('cheio');
    });

    //fixar menu no topo
    /* var menu = $('header').offset().top;
    $(window).scroll(function () {
        if ($(window).scrollTop() > menu) {
            $('header').addClass('fixed');
        } else {
            $('header').removeClass('fixed');
        }
    });*/

    $('[js-sidebar-abrir-submenu]').on('click', function (e) {
        e.preventDefault();
        $(this).toggleClass('open');
        $(this).siblings('[js-sidebar-submenu]').slideToggle();
    });

    $('[js-btn-sidebar]').on('click', function () {
        $(this).toggleClass('open');
        $(this).siblings('[js-menu-sidebar]').slideToggle();
    });

    $('[js-btn-dados-comprador]').on('click', function(e){
        e.preventDefault();
        $('[js-dados-comprador]').slideDown();
        $("html, body").animate({ scrollTop: $('[js-dados-comprador]').offset().top - 50}, 600);
    });

    $('[js-fechar-cx-confirmacao]').on('click', function () {
        $('[js-cx-confirmacao]').fadeOut();
    });

    /**********************AÇÃO***********************/

    // Forms
    $('[type=file]').on('change', function (e) {
        let elemento = $(this);
        let nome = elemento.attr('name');
        let pai = elemento.closest('label');
        let raiz = pai.closest('form');
        let ajaxurl = $('#url_ajax').val();

        if (ajaxurl == '') {
            pai.find('span').html(e.target.files[0].name);
            pai.addClass('cheio');
        } else {
            raiz.find('[type=submit]').attr('disabled', 'disabled');

            elemento.simpleUpload(ajaxurl + '?action=upload&name=' + nome, {
                start: function () {
                    pai.find('span').html('Enviando...');
                },
                success: function (retorno) {
                    raiz.find(`[name="${nome}_url"]`).remove();
                    raiz.append(`<input type='hidden' name="${nome}_url" value="${retorno}">`);
                    raiz.find('[type=submit]').removeAttr('disabled');

                    pai.find('span').html(e.target.files[0].name);
                    pai.addClass('cheio');
                }
            });
        }
    });

    $('[js-formulario]').on('submit', function (e) {
        e.preventDefault();
        let form = $(this);
        let elemento = form.find('[type="submit"]');
        let raiz = elemento.closest('[js-form]');

        raiz.find('.obrigatorio').removeClass('obrigatorio');
        form.find('[js-form-erro]').addClass('hidden');

        $.each(raiz.find('[required]'), function () {
            let campo = $(this);
            if (campo.val() == '') {
                campo.focus();
                campo.parent().addClass('obrigatorio');
                return false;
            }
        });

        if (raiz.find('.obrigatorio').length > 0) {
            return false;
        }

        var ajaxurl = $('#url_ajax').val();

        var data = form.serializeArray();

        $.ajax({
            url: ajaxurl,
            type: 'post',
            data: data,
            beforeSend: function () {
                elemento.attr('disabled', 'disabled').data('original', elemento.text()).text('Aguarde...');
            },
            success: function (retorno) {
                if (retorno != '1') {
                    form.find('[js-form-erro]').html(retorno).removeClass('hidden');
                    elemento.removeAttr('disabled').text(elemento.data('original'));
                } else {
                    form.addClass('hidden');
                    raiz.find('[js-form-sucesso]').removeClass('hidden');
                }
            }
        });
    });

    $('[js-formulario-newsletter]').on('submit', function (e) {
        e.preventDefault();
        let form = $(this);
        let elemento = form.find('[type="submit"]');
        let raiz = elemento.closest('[js-form-newsletter]');

        raiz.find('.obrigatorio').removeClass('obrigatorio');

        $.each(raiz.find('[required]'), function () {
            let campo = $(this);
            if (campo.val() == '') {
                campo.focus();
                campo.parent().addClass('obrigatorio');
                return false;
            }
        });

        if (raiz.find('.obrigatorio').length > 0) {
            return false;
        }

        var ajaxurl = $('#url_ajax').val();

        var data = form.serializeArray();

        $.ajax({
            url: ajaxurl,
            type: 'post',
            data: data,
            beforeSend: function () {
                elemento.attr('disabled', 'disabled').data('original', elemento.text()).text('Aguarde...');
            },
            success: function (retorno) {
                if (retorno != '1') {
                    elemento.removeAttr('disabled').text(elemento.data('original'));
                    raiz.find('[js-form-erro]').removeClass('hidden');
                } else {
                    elemento.text(elemento.data('original'))
                    form.find('input').attr('readonly', 'readonly');
                    raiz.find('[js-form-sucesso]').removeClass('hidden');
                }
            }
        });
    });

    $('[js-carregar-mais]').on('click', function (e) {
        e.preventDefault();
        let elemento = $(this);
        let ajaxurl = $('#url_ajax').val();
        let dados = {};

        dados.action = 'carregar_mais';
        dados.pagina = (parseInt(elemento.attr('pagina')) == '' || parseInt(elemento.attr('pagina')) == undefined) ? 1 : parseInt(elemento.attr('pagina'));
        dados.post_type = elemento.attr('js-carregar-mais');
        dados.por_pagina = elemento.attr('por-pagina');
        dados.arquivo = elemento.attr('arquivo');

        $.ajax({
            url: ajaxurl,
            type: 'post',
            data: dados,
            success: function (retorno) {
                let top = $(window).scrollTop();

                retorno = JSON.parse(retorno);

                $(elemento.attr('destino')).append(retorno.html);

                $(window).scrollTop(top);

                if (!retorno.acabou) {
                    elemento.attr('pagina', dados.pagina + 1);
                } else {
                    elemento.remove();
                }
            }
        });
    });

    $('[js-adicionar]').on('click', function (e) {
        e.preventDefault();
        let elemento = $(this);

        let codigo = elemento.attr('js-codigo');
        let link = elemento.attr('js-link');
        let imagem = elemento.attr('js-imagem');
        let titulo = elemento.attr('js-titulo');

        let item = {};
        item.codigo = codigo;
        item.link = link;
        item.imagem = imagem;
        item.titulo = titulo;
        item.quantidade = 1;

        adicionarItemCarrinho(item);

        atualizarQuantidade();

    });

    $('[js-qtd-mais]').on('click', function (e) {
        e.preventDefault();

        let elemento = $(this);
        let campoQtd = $(this).siblings('[js-qtd-campo]');
        let qtd = 0;

        qtd = campoQtd.val();

        qtd = qtd - 0 + 1;
        campoQtd.val(qtd);

        let item = {};
        item.codigo = elemento.closest('[js-codigo]').attr('js-codigo');
        item.quantidade = qtd;

        atualizarItemCarrinho(item);
    });

    $('[js-qtd-menos]').on('click', function (e) {
        e.preventDefault();

        let elemento = $(this);
        let campoQtd = $(this).siblings('[js-qtd-campo]');
        let qtd = 0;

        qtd = campoQtd.val();

        if (qtd > 1) {
            qtd = qtd - 1;
            campoQtd.val(qtd);

            let item = {};
            item.codigo = elemento.closest('[js-codigo]').attr('js-codigo');
            item.quantidade = qtd;

            atualizarItemCarrinho(item);
        }
    });

    $(document).on('click', '[js-excluir-produto]', function(e){
        e.preventDefault();

        let elemento = $(this);
        var produto = elemento.closest('[js-codigo]');

        produto.remove();

        var codigo = elemento.closest('[js-codigo]').attr('js-codigo');
        removerItemCarrinho(codigo);

        let carrinho = buscarCarrinho();

        if(carrinho.length > 0){
            $('[js-sem-itens]').hide();
            $('[js-com-itens]').show();
        }else{
            $('[js-com-itens]').hide();
            $('[js-sem-itens]').show();
            $('[js-finalizar-orcamento]').hide();
        }

        atualizarQuantidade();
    });

    $('[js-finalizar-orcamento]').click(function(e){
        e.preventDefault();

        var elemento = $(this);
        var ajaxurl = $('#url_ajax').val();

        if($('[name="nome_orc"]').val() == ''){
            $('[name="nome_orc"]').parent().addClass('obrigatorio');
            return false;
        }

        if($('[name="email_orc"]').val() == ''){
            $('[name="email_orc"]').parent().addClass('obrigatorio');
            return false;
        }

        if($('[name="telefone_orc"]').val() == ''){
            $('[name="telefone_orc"]').parent().addClass('obrigatorio');
            return false;
        }

        if($('[name="cidade_orc"]').val() == ''){
            $('[name="cidade_orc"]').parent().addClass('obrigatorio');
            return false;
        }

        var dados = {};
        dados.nome = $('[name="nome_orc"]').val();
        dados.cidade = $('[name="cidade_orc"]').val();
        dados.email = $('[name="email_orc"]').val();
        dados.telefone = $('[name="telefone_orc"]').val();
        dados.observacoes = $('[name="observacoes_orc"]').val();

        var data = {
            'action' : 'enviar_orcamento',
            'produtos' : buscarCarrinho(),
            'cliente' : dados,
        };

        $.ajax({
            url: ajaxurl,
            type: 'post',
            data: data,
            success: function(retorno) {
                sessionStorage.removeItem('carrinho');
                $('[js-carrinho], [js-finalizar-orcamento], [js-com-itens], [js-orcamento-finalizado]').hide();
                $('[js-orcamento-enviado]').show();
                $("html, body").animate({scrollTop: 0}, 600);

                atualizarQuantidade();
            }
        })
    });

    $('input, textarea').on('focus', function (e) {
        $(this).parent().removeClass('obrigatorio');
    });

    $('input, textarea').on('blur', function (e) {
        let elemento = $(this);
        if (elemento.val() != '') {
            elemento.parent().removeClass('obrigatorio');
        }
    });

    $('.alerta-news__fechar').on('click', function (e) {
        e.preventDefault();
        $(this).closest('.alerta-news').fadeOut();
    });

    // Fim forms


    /******************INICIALIZAÇÃO******************/

    // Inicializa o ligthbox
    $("[data-fancybox]").fancybox({
        loop: true,
        toolbar: true,
        infobar: false,
        animationEffect: "zoom-in-out",
        transitionEffect: "slide",
        lang: 'pt',
        i18n: {
            'pt': {
                CLOSE: 'Fechar',
                THUMBS: 'Miniaturas',
                FULL_SCREEN: 'Tela cheia',
                PLAY_START: 'Transição automática',
                NEXT: 'Próximo',
                PREV: 'Anterior',
            }
        },
    });
    $("[data-modal]").fancybox({
        modal: true,
        toolbar: false,
        smallBtn: false,
        touch: {
            vertical: false, // Allow to drag content vertically
            momentum: false // Continue movement after releasing mouse/touch when panning
        },
    });

    // Swiper Home
    var swiper = new Swiper('.swiper-home', {
        spaceBetween: 30,
        effect: 'fade',
        loop: true,
        autoplay: {
            delay: 2500,
            disableOnInteraction: true,
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        breakpoints: {
            320: {
                slidesPerView: 1,
                spaceBetween: 10
            },
            480: {
                slidesPerView: 2,
                spaceBetween: 20
            },
            640: {
                slidesPerView: 3,
                spaceBetween: 30
            }
        }
    });

    var produtoThumbs = new Swiper('.produto-thumbs', {
        spaceBetween: 4.5,
        slidesPerView: 4,
        freeMode: true,
        watchSlidesVisibility: true,
        watchSlidesProgress: true,
    });

    var produtoSlide = new Swiper('.produto-slide', {
        thumbs: {
            swiper: produtoThumbs
        }
    });

    /*MÁSCARA*/
    var SPMaskBehavior = function (val) {
        return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
    }, spOptions = {
        onKeyPress: function (val, e, field, options) {
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        }
    };
    $('[mascara="telefone"]').mask(SPMaskBehavior, spOptions);
    $('[mascara="cnpj"]').mask('00.000.000/0000-00');
    $('[mascara="cpf"]').mask('000.000.000-00');
    $('[mascara="dinheiro"]').mask('#.##0,00', { reverse: true });

    //parallax
    $('[data-speed-factor]').each(function () {
        var speedFactor = parseFloat($(this).data('speed-factor')) || 0.1;
        $(this).parallax(speedFactor);
    });

});

function getEndereco() {
    $("[js-cep]").focusout(function () {
        //Início do Comando AJAX
        $.ajax({
            //O campo URL diz o caminho de onde virá os dados
            //É importante concatenar o valor digitado no CEP
            url: 'https://viacep.com.br/ws/' + $(this).val() + '/json/unicode/',
            //Aqui você deve preencher o tipo de dados que será lido,
            //no caso, estamos lendo JSON.
            dataType: 'json',
            //SUCESS é referente a função que será executada caso
            //ele consiga ler a fonte de dados com sucesso.
            //O parâmetro dentro da função se refere ao nome da variável
            //que você vai dar para ler esse objeto.
            success: function (resposta) {
                //Agora basta definir os valores que você deseja preencher
                //automaticamente nos campos acima.
                $('[js-rua]').val(resposta.logradouro);
                $('[js-bairro]').val(resposta.bairro);
                $('[js-cidade]').val(resposta.localidade);
                $('[js-uf]').val(resposta.uf);
                //Vamos incluir para que o Número seja focado automaticamente
                //melhorando a experiência do usuário
                $('[js-numero]').focus();
            }
        });
    });
}

function verificarTamanho() {
    let tamanhoJanela = $(window).width();
    let container = 0;
    if (tamanhoJanela >= 1200) {
        container = 1140;
    } else if (tamanhoJanela >= 992) {
        container = 960;
    } else if (tamanhoJanela >= 768) {
        container = 720;
    } else {
        container = 540;
    }
    let bordasJanela = (tamanhoJanela - container) / 2 + 15;

    let retorno = {};
    retorno.tamanhojanela = tamanhoJanela;
    retorno.bordasjanela = bordasJanela;

    return retorno;
}

function tamanhoImagens() {
    let tamanhos = verificarTamanho();

    $.each($('[data-tamanho-dinamico]'), function () {
        let elemento = $(this);
        if (tamanhos.tamanhojanela > 575) {
            if (elemento.data('limite') == undefined || elemento.data('limite') < tamanhos.tamanhojanela) {
                elemento.css('width', 'calc(100% + ' + tamanhos.bordasjanela + 'px)');
            }
        } else {
            if (elemento.data('limite') == undefined || elemento.data('limite') < tamanhos.tamanhojanela) {
                elemento.css('width', 'calc(100% + 30px)');
                elemento.css('margin-left', '-15px');
            }
        }
    });
}

function tamanhoMenu() {
    let tamanhos = verificarTamanho();
    let tamanhoFinal = tamanhos.bordasjanela + 290;

    if (tamanhos.tamanhojanela > 575) {
        $('[data-tamanho-menu]').css('max-width', tamanhoFinal + 'px');
    } else {
        $('[data-tamanho-menu]').css('max-width', '305px');
    }
}

function is_mobile() {
    $('body').append('<div class="visible-mobile" id="mobile-visible-test" />');
    var result = $('.visible-mobile').is(':visible');
    $('#mobile-visible-test').remove();
    return result;
}

function buscarCarrinho(){
    let carrinho = sessionStorage.carrinho;

    if(carrinho != undefined){
        carrinho = JSON.parse(carrinho);
    }else{
        carrinho = [];
    }

    return carrinho;
}

function guardarCarrinho(carrinho){
    sessionStorage.carrinho = JSON.stringify(carrinho);
}

function adicionarItemCarrinho(item){
    let carrinho = buscarCarrinho();

    let atual = carrinho.find(x => x.codigo === item.codigo);
    let produto = $(`button[js-codigo="${item.codigo}"]`);
    if(atual == undefined){
        carrinho.push(item);
        produto.find('[js-adicionado]').hide();
        produto.find('[js-removido]').show();
        guardarCarrinho(carrinho);
        $('[js-confirmacao-adicionar]').fadeIn();
        setTimeout(function(){
            $('[js-confirmacao-adicionar]').fadeOut();
        }, 2000);
    } else {
        produto.find('[js-adicionado]').show();
        produto.find('[js-removido]').hide();
        removerItemCarrinho(item.codigo);
        $('[js-confirmacao-remover]').fadeIn();
        setTimeout(function(){
            $('[js-confirmacao-remover]').fadeOut();
        }, 2000);
    }

    atualizarQuantidade();
}

function atualizarItemCarrinho(item){
    let carrinho = buscarCarrinho();
    item.quantidade = parseInt(item.quantidade);

    let atual = carrinho.find(x => x.codigo === item.codigo);
    if(atual != undefined){
        atual.quantidade = parseInt(item.quantidade);
        guardarCarrinho(carrinho);
    }
}

function atualizarQuantidade() {

    let carrinho = buscarCarrinho();
    let quantidade = 0;
    if(carrinho.length > 0){
        quantidade = carrinho.length;
    }

    $('[js-quantidade-carrinho]').html(quantidade + (quantidade != 1 ? ' itens' : ' item'));
}

function removerItemCarrinho(codigo){
    let carrinho = buscarCarrinho();

    carrinho = carrinho.filter(function(x){
        return x.codigo != codigo;
    });

    guardarCarrinho(carrinho);
}