<?php

/*
 * IMPORTANTE:
 * chamar o endereço: http://www.nomedosite.com.br/wp-admin/admin-ajax.php?action=log_formularios
 * para fazer a criação das tabelas do banco de dados
 *
*/


	/* página no painel para listr cadastrados na newsletter */
	add_action('admin_menu', 'bravo_interativa_log_formularios');
	function bravo_interativa_log_formularios() {
		global $forms;
		if ( ! current_user_can('edit_pages') ) return;
		add_menu_page('Contatos', 'Contatos', null, "log-formularios", 'bravo_interativa_log_formularios', 'dashicons-email' );
		foreach($forms as $key => $form){
			add_submenu_page('log-formularios', $form, $form, 'edit_pages', 'log-formularios-listagem-'.$key, 'bravo_interativa_log_formularios_listagem' );
			add_submenu_page(null, $form, $form, 'edit_pages', 'log-formularios-detalhamento-'.$key, 'bravo_interativa_log_formularios_detalhamento' );
		}
	}


if(!function_exists('log_contato')){
	function log_contato($de,$para,$nome,$email,$assunto,$texto, $tipo){
		try{
			global $wpdb;
			$log_form["de"] = $de;
			$log_form["para"] = $para;
			$log_form["nome"] = $nome;
			$log_form["email"] = $email;
			$log_form["assunto"] = $assunto;
			$log_form["texto"] = $texto;
			$log_form["tipo"] = $tipo;
			$wpdb->insert($wpdb->prefix.'bravologformularios',$log_form);
		} catch (Exception $e) {

		}
	}
}

function bravo_interativa_log_formularios_listagem(){
	$screen = get_current_screen();
	$type = explode('-', $screen->id);
	$type = $type[3];
	?>


<div class="wrap">

	<h2><?php echo get_admin_page_title(); ?></h2>

	<form id="posts-filter" method="get">
		<input type="hidden" id="page" name="page" value="log-formularios-listagem">
		<input type="search" id="post-search-input" name="s" value="<?php echo (!empty($_GET['s'])) ? $_GET['s'] : ''; ?>">
		<input type="submit" id="post-query-submit" class="button" value="Filtrar">
	</form>

	<?php

	global $wpdb;

	/* Caracteres buscados */
	if (isset($_GET["s"])){
		$s = $_GET["s"];
	}else{
		$s = '';
	}

	/* Se clicou em excluir */
	if (isset($_POST["excluir"])){
		$id = $_POST["excluir"];
	}else{
		$id = '';
	}


	if(!empty($_POST["resposta"]) && $_POST["resposta"]=="sim" && !empty($id)){
		$ok = $wpdb->delete( $wpdb->prefix.'bravologformularios',array('ID'=>$id));
		if($ok){
			$_POST['excluir'] = null;
		}
	}else{
		if (!empty($_POST['excluir'])){ ?>
		<div class="error notice is-dismissible">
			<form method="post" id="excluir_sim">

				<input type="hidden" id="page" name="page" value="log-formularios-listagem">
				<input type="hidden" id="excluir" name="excluir" value="<?php echo $_POST["excluir"]; ?>">
				<input type="hidden" id="resposta" name="resposta" value="sim">

				<p>Tem certeza que deseja excluir o contato? <input class="excluir-registro" type="submit" value="Sim"></p>
			</form>
		</div>
		<?php
	}
}


/* Registro por página */
$num_per_page=30;

/* Descobre a página atual */
if (!empty($_GET["paged"])) { $p  = $_GET["paged"]; } else { $p=1; };

/* Offset */
$start_from = ($p-1) * $num_per_page;

/* Converte s em data (caso for inserido uma) */
$dt = implode("-",array_reverse(explode("/",$s)));

/* Monta o SQL */
$sql = "SELECT * FROM ".$wpdb->prefix."bravologformularios WHERE tipo = '".$type."' ";
if(!empty($s)){ $sql .= "AND texto LIKE '%".$s."%' OR dt_criacao LIKE '%".$dt."%' ";}
$sql .= "ORDER BY dt_criacao DESC LIMIT ".$start_from.", ".$num_per_page;

/* Resultados a exibir */
$list = $wpdb->get_results($sql,ARRAY_A);

$showing = $wpdb->num_rows;
?>

<table class="wp-list-table widefat">
	<thead>
		<tr>
			<th>Data</th>
			<th>Nome</th>
			<th>E-mail</th>
			<th>Assunto</th>
			<th>Ações</th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (!empty($list)) {
			$i = 0;
			$class = array('','alternate');
			foreach ($list as $item) {
				$i = 1 - $i;
				$data = explode(" ", $item["dt_criacao"]);
				preg_match("/Nome.*?<td.*?>(.*?)<\/td>/xmsi", $item["texto"],$match);
				$nome = $match[1];
				preg_match("/(Depoimento|Mensagem)<\/td>.*?<td.*?>(.*?)<\/td>/xmsi", $item["texto"],$match);
				$texto = substr($match[2],0,100).'...';
				?>
				<tr class="<?php echo $class[$i]; ?>">
					<td><?php echo $data[1] . ' ' . implode("/",array_reverse(explode("-",$data[0]))); ?></td>
					<td><?php echo $item["nome"] ?></td>
					<td><?php echo $item["email"] ?></td>
					<td><?php echo $item["assunto"] ?></td>
					<td>


						<form method="post">
							<input type="hidden" id="page" name="page" value="log-formularios-listagem">
							<input type="hidden" id="excluir" name="excluir" value="<?php echo $item["id"]; ?>">

							<a href="<?php echo admin_url('admin.php?page=log-formularios-detalhamento-'.$type.'&id='.$item["id"]) ?>">Detalhes</a> | <input class="excluir-registro" type="submit" value="Excluir" style="background: none; border: none; color: #80120A; font-size: 13px; cursor: pointer;">
						</form>
					</td>
				</tr>
				<?php }
			} else {  ?>
			<tr><td>Sem resultados</td></tr>

			<?php	} ?>
		</tbody>
		<tfoot>
			<tr>
				<th>Data</th>
				<th>Nome</th>
				<th>E-mail</th>
				<th>Assunto</th>
				<th>Ações</th>
			</tr>
		</tfoot>
	</table>

	<?php

	/* Monta o SQL */
	$sql = "SELECT * FROM ".$wpdb->prefix."bravologformularios WHERE tipo = '".$type."' ";
	if(!empty($s)){ $sql .= "WHERE texto LIKE '%".$s."%' OR dt_criacao LIKE '%".$dt."%' ";}

	$result = $wpdb->get_results($sql,ARRAY_A);

				$total_records = $wpdb->num_rows;  //count number of records
				$total_pages = ceil($total_records / $num_per_page);
				?>

				<div class="tablenav bottom">
					<div class="tablenav-pages"><span class="displaying-num"><?php echo 'Exibindo '.$showing.' de '.$total_records.' itens'; ?></span>

						<?php

						echo paginate_links(array(
							'base' => str_replace( '&#038;', '&', esc_url( get_pagenum_link( 1 ) . '%_%' ) ),
							'format' => '&paged=%#%',
							'current' => $p,
							'total' => $total_pages,
							'prev_text' => '‹',
							'next_text' => '›',
							'add_args' => false,
							));
							?>
						</div>
					</div>
				</div>
				<?php
			}

			function bravo_interativa_log_formularios_detalhamento(){
				$screen = get_current_screen();
				$type = explode('-', $screen->id);
				$type = $type[3];


				global $wpdb;
				$id = $_GET["id"];
				$item = $wpdb->get_row('select * from '.$wpdb->prefix.'bravologformularios where id='.$id,ARRAY_A);
				$data = explode(" ", $item["dt_criacao"]);
				?>

				<h2>Histórico</h2>
				<table class="wp-list-table widefat">
					<tbody>
						<tr>
							<th>Data: </th>
							<td><?php echo $data[1] . ' ' . implode("/",array_reverse(explode("-",$data[0]))); ?></td>
						</tr>
						<tr>
							<th>Assunto: </th>
							<td><?php echo $item["assunto"] ?></td>
						</tr>
						<tr>
							<th>Para: </th>
							<td><?php echo $item["para"] ?></td>
						</tr>
						<tr>
							<th>Texto: </th>
							<td align="left"><?php echo preg_replace("/.*<body[^>]*>(.*)<\/body>.*/xmsi", "$1", $item["texto"]) ?></td>
						</tr>
						<tr>
							<th></th>
							<td><a href="<?php echo admin_url('admin.php?page=log-formularios-listagem-'.$type) ?>" class="button">Voltar</a></td>
						</tr>
					</tbody>
				</table>
				<?php
			}





/* criação da tabela */
add_action('wp_ajax_log_formularios', 'log_formularios_ajax');
function log_formularios_ajax() {
	global $wpdb;
	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	$sql = "CREATE TABLE ".$wpdb->prefix."bravologformularios (
	id integer auto_increment NOT NULL,
	dt_criacao timestamp default CURRENT_TIMESTAMP,
	de varchar(255) NOT NULL,
	para varchar(255) NOT NULL,
	nome varchar(255) NOT NULL,
	email varchar(255) NOT NULL,
	assunto varchar(255) NOT NULL,
	texto text,
	tipo varchar(50) NOT NULL,
	PRIMARY KEY (id)
	);";
	$ok = dbDelta( $sql );
	var_dump($ok);
	die();
}

/* limpar contatos */
/*add_action('wp_ajax_log_formularios_delete', 'log_formularios_ajax_delete');
function log_formularios_ajax_delete() {
	global $wpdb;
	$ok = $wpdb->delete( $wpdb->prefix.'bravologformularios',array('1'=>'1'));
	var_dump($ok);
	exit;
}*/