<?php get_header(); ?>

<main id="home">
    <div class="banner" data-image-src="<?php echo get_field('imagem_central_background', $post->ID)['sizes']['large']; ?>" style="background-image: url(<?php echo get_field('imagem_central_background', $post->ID)['sizes']['large']; ?>)">
        <div class="container">
            <h1><?php echo get_field('titulo_apoio', $post->ID); ?></h1>
            <p class="titulo-padrao"><?php echo get_field('titulo_central', $post->ID); ?></p>
            <a href="<?php echo site_url('servicos'); ?>" class="btn-padrao btn-padrao--laranja">Conheça nossos serviços</a>
        </div>
    </div>
    <div class="itens-home">
        <div class="container">
            <div class="grid-itens">
                <div>
                    <?php include 'images/svg/certificacao.svg'; ?>
                    <p>Profissionais com Certificação em NR 10, NR 20 e NR 35</p>
                </div>
                <div>
                    <?php include 'images/svg/vida-util.svg'; ?>
                    <p>Aumento da vida útil dos equipamentos</p>
                </div>
                <div>
                    <?php include 'images/svg/custo.svg'; ?>
                    <p>Redução dos custos com manutenção corretiva</p>
                </div>
                <div>
                    <?php include 'images/svg/contaminacao.svg'; ?>
                    <p>Redução de riscos de contaminação do combustível com àgua e/ou impurezas</p>
                </div>
                <a href="<?php echo caminho_imagem('210809-SASC-005-2021-JS_ENGENHARIA-ASSINADO.pdf') ?>" target="_blank">
                    <?php include 'images/svg/sasc.svg'; ?>
                    <p>Empresa acreditada para serviço de instalação/remoção de SASC</p>
                </a>
                <a href="<?php echo caminho_imagem('201208-_CTBC-TEPS-005-2020-_JS_ENGENHARIA-_ASSINADO.pdf') ?>" target="_blank">
                    <?php include 'images/svg/estanqueidade.svg'; ?>
                    <p>Empresa acreditada para testes de estanqueidade</p>
                </a>
            </div>
        </div>
    </div>
    <?php $imagem_banner = get_field('imagem_banner');
    if (!empty($imagem_banner)) { ?>
        <div class="banner" data-image-src="<?php echo $imagem_banner['sizes']['large']; ?>" style="background-image: url('<?php echo $imagem_banner['sizes']['large']; ?>')">
            <div></div>
            <div class="banner__box">
                <?php include 'images/logo.svg'; ?>
                <h1><?php the_field('frase_banner'); ?></h1>
            </div>
            <a href="#categorias" data-ancora-suave class="seta-down" title="Descer"></a>
        </div>
    <?php
    } // if !empty imagem_banner 
    ?>
</main>

<section class="home-servicos">
    <div class="container">
        <div class="row justify-content-center align-items-end">
            <div class="col-md-7 col-lg-6">
                <h2 class="titulo-padrao"><?php echo get_field('titulo_bloco_servicos', $post->ID); ?></h2>
                <p class="legenda"><?php echo get_field('texto_bloco_servicos', $post->ID); ?></p>
            </div>
            <div class="col-md-5 col-lg-3 offset-lg-1">
                <a href="#ft_bl-contato" js-ancora-suave class="btn-padrao btn-padrao--laranja">Solicite orçamento</a>
            </div>
        </div>
        <div class="grid-servicos">
            <?php
            $args = get_args('servico', -1);
            listar($args, '_servico.php');
            ?>
        </div>
    </div>
</section>

<section class="bloco-sobre">
    <img src="<?php echo get_field('imagem_background_bloco_secundario', $post->ID)['sizes']['large']; ?>" alt=" ">
    <div class="container">
        <div class="row no-gutters">
            <div class="col-lg-8 offset-lg-4">
                <div class="box-infos">
                    <h2><?php echo get_field('titulo_bloco_secundario', $post->ID); ?></h2>
                    <p><?php echo get_field('texto_bloco_secundario', $post->ID); ?></p>
                    <p class="certificacao"><?php svg('icon-certificacao-nr') ?> Profissionais com Certificação em NR 10, NR 20 e NR 35.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="home-produtos">
    <div class="container">
        <h2>Conheça também nossas linhas de produtos</h2>
        <div class="produtos-grid">
            <?php $args = get_args('produto', 4);
            $paginacao = listar($args, '_produto.php'); ?>
        </div>
        <div class="d-flex align-items-center justify-content-center">
            <a href="<?php echo site_url('produtos') ?>" class="btn-padrao">Ver todos produtos</a>
        </div>
    </div>
</section>

<div class="home-clientes">
    <div class="container">
        <h2 class="sidebar__titulo">Clientes JS Engenharia</h2>
        <?php $clientes = get_field('clientes', 69); ?>
        <div class="grid-clientes">
            <?php foreach ($clientes as $cliente) { ?>
                <div><img src="<?php echo $cliente['imagem']['sizes']['large'] ?>" alt=" "></div>
            <?php } // foreach $clientes 
            ?>
        </div>
    </div>
</div>

<?php include '_bloco-contato.php'; ?>

<?php get_footer(); ?>