<?php get_header(); ?>

<main id="contato" class="pagina">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <h1 class="titulo-padrao">Contato</h1>
                <p class="legenda">Fale conosco através do formulário ou pelos contatos abaixo:</p>
            </div>
        </div>
        <div class="row justify-content-md-end flex-md-row-reverse">
            <div class="col-md-5 col-lg-4 col-xl-3 offset-xl-2">
                <div class="infos-contatos">
                    <h2>E-mail</h2>
                    <a class="email" href="mailto:comercial@jsengenhariars.com.br">comercial@jsengenhariars.com.br</a>
                    <a class="email" href="mailto:lucas@jsengenhariars.com.br">lucas@jsengenhariars.com.br</a>
                    <h2>Telefones (comerciais)</h2>
                    <a href="//api.whatsapp.com/send?phone=5551980423335" target="_blank" class="telefone">51 98042-3335</a>
                    <a href="//api.whatsapp.com/send?phone=5551999556301" target="_blank" class="telefone">51 51 99955-6301</a>
                    <h2>Telefones (administrativo)</h2>
                    <p class="telefone">51 3748-4699</p>
                    <a href="//api.whatsapp.com/send?phone=5551995191232" target="_blank" class="telefone">51 99519-1232</a>
                    <h2>Endereço</h2>
                    <address class="endereco">
                        Rua General Flores da Cunha, 499 - Florestal<br>
                        CEP: 95900-626 - Lajeado / RS
                    </address>
                    <a class="link-mapa" href="//goo.gl/maps/mXAare4ACQabSxZn9" target="_blank"><?php svg('icon-pin-simples') ?>Ver no mapa</a>
                </div>
            </div>
            <div class="col-md-6 col-lg-5 col-xl-4 offset-lg-1">
                <div js-form>
                    <form method="post" action="<?php echo admin_url('admin-ajax.php'); ?>" class="form" js-formulario>
                        <div class="hidden"><input name="trap" placeholder="Trap"></div>
                        <input type="hidden" name="action" value="contact">
                        <div class="form__group">
                            <label class="label" for="nome">Nome</label>
                            <input type="text" name="nome" id="primeiroCampo" placeholder="Nome" required>
                        </div>
                        <div class="form__group">
                            <label class="label" for="email">E-mail</label>
                            <input type="email" name="email" placeholder="E-mail" required>
                        </div>
                        <div class="form__group">
                            <label class="label" for="telefone">Telefone</label>
                            <input type="text" name="telefone" mascara="telefone" placeholder="Telefone" required>
                        </div>
                        <div class="form__group">
                            <label class="label" for="cidade">Cidade</label>
                            <input type="text" name="cidade" mascara="cidade" placeholder="Cidade" required>
                        </div>
                        <div class="form__group">
                            <label class="label" for="mensagem">Digite sua mensagem</label>
                            <textarea name="mensagem" placeholder="Digite sua mensagem" required></textarea>
                        </div>

                        <div js-form-erro class="alerta-form--fail hidden">Por favor, preencha todos os campos</div>

                        <button type="submit" class="btn-padrao">Enviar</button>
                    </form>
                    <div js-form-sucesso class="alerta-form--success hidden">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 510.06 240.83">
                            <defs>
                                <clipPath id="clip-path" transform="translate(0)">
                                    <rect fill="none" width="510.06" height="240.83" />
                                </clipPath>
                            </defs>
                            <g clip-path="url(#clip-path)">
                                <path d="M215.7,195a9.21,9.21,0,0,0,6.8,3.1,8.71,8.71,0,0,0,6-2.3l78.3-69,25.4,19.7a8.83,8.83,0,0,0,5.6,1.9,9,9,0,0,0,5.6-1.9l26.2-20.3,77.5,69.5a8.71,8.71,0,0,0,6,2.3,9.05,9.05,0,0,0,6.1-15.8l-75-67.3L458.8,57a9.05,9.05,0,1,0-11.1-14.3L337.8,128,312,107.9,228.1,42.8A9.05,9.05,0,1,0,217,57.1l75.3,58.5-75.7,66.7a8.85,8.85,0,0,0-.9,12.7" transform="translate(0)" />
                                <path d="M117.6,129.1a9.1,9.1,0,1,0,0-18.2h-72a9.1,9.1,0,0,0,0,18.2Z" transform="translate(0)" />
                                <path d="M9.1,81.2H117.6a9.1,9.1,0,1,0,0-18.2H9.1a9.1,9.1,0,0,0,0,18.2" transform="translate(0)" />
                                <path d="M126.7,167.9a9.13,9.13,0,0,0-9.1-9.1H70.2a9.1,9.1,0,0,0,0,18.2h47.4a9.13,9.13,0,0,0,9.1-9.1" transform="translate(0)" />
                                <path d="M492.19,240.83H183.64A17.89,17.89,0,0,1,165.77,223V17.87A17.89,17.89,0,0,1,183.64,0H492.19a17.89,17.89,0,0,1,17.87,17.87V223a17.89,17.89,0,0,1-17.87,17.87m0-18Zm-308.42,0H492.06V18H183.77Z" transform="translate(0)" />
                            </g>
                        </svg>
                        <p>Mensagem enviada<br>com sucesso</p>
                        <a href="">ok</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php get_footer(); ?>