<?php get_header(); ?>

<main id="ft_sobre" class="pagina">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-1">
                <h1 class="titulo-padrao">Quem Somos</h1>
                <p class="legenda"><?php echo get_field('legenda'); ?></p>
            </div>
            <div class="col-lg-10 offset-lg-1">
                <div class="lista-servicos editor">
                    <?php echo get_field('quem_somos'); ?>
                </div>
            </div>
        </div>

        <div class="bloco-galeria">
            <?php $galeria = get_field('galeria'); ?>
            <div class="grid-galeria">
                <?php foreach ($galeria as $imagem) { ?>
                    <a href="<?php echo $imagem['sizes']['large'] ?>" data-fancybox="galeria"><img src="<?php echo $imagem['sizes']['thumbnail'] ?>" alt="<?php echo $imagem['alt'] ?>"></a>
                <?php } // foreach $galeria 
                ?>
            </div>
        </div>
        <!--p class="orientacao-deslizar visible-mobile hidden-sm hidden-md">Deslize para ver mais fotos <?php /* svg('icon-seta') */ ?></p-->

        <?php $atuacao = get_field('atuacao'); ?>
        <div class="area-mapa">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-5 col-lg-4 offset-lg-1">
                        <div class="area-mapa__infos">
                            <?php svg('icon-pin'); ?>
                            <h2><?php echo $atuacao['titulo']; ?></h2>
                            <p><?php echo $atuacao['texto']; ?></p>
                        </div>
                    </div>
                    <div class="col-md-7">
                        <img src="<?php caminho_imagem('mapa.png') ?>" alt=" ">
                    </div>
                </div>
            </div>
        </div>

        <?php $equipe = get_field('equipe'); ?>
        <div class="texto-certificacao">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <img class="img-responsive" src="<?php echo $equipe['imagem']['sizes']['medium'] ?>" alt=" ">
                </div>
                <div class="col-md-6">
                    <div class="editor">
                        <p><?php echo $equipe['texto'] ?></p>
                        <p class="certificacao"><?php svg('icon-certificacao-nr') ?> Profissionais com Certificação em NR 10, NR 20 e NR 35.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="editor">
                    <?php echo get_field('conteudo'); ?>
                </div>
            </div>
        </div>

    </div>
</main>

<?php get_footer(); ?>