<?php get_header(); ?>

<div id="produto">
    <div class="container">
        <div class="pagina-produtos">

            <?php include '_sidebar.php'; ?>

            <main class="produtos">
                <div class="cabecalho-produto">
                    <div class="breadcrumb">
                        <?php
                        $categorias = array();
                        $categoria = wp_get_post_terms($post->ID, 'categoria');
                        $categorias[] = array('nome' => $categoria[0]->name, 'slug' => $categoria[0]->slug);
                        $ancestrais = get_ancestors($categoria[0]->term_id, 'categoria', 'taxonomy');
                        foreach ($ancestrais as $ancestral) {
                            $term = get_term_by('term_id', $ancestral, 'categoria');
                            $categorias[] = array('nome' => $term->name, 'slug' => $term->slug);
                        } // foreach ancestrais

                        foreach (array_reverse($categorias) as $categoria) { ?>
                            <a href="<?php echo site_url('/categoria/'.$categoria['slug']); ?>" class="breadcrumb__link"><?php echo $categoria['nome']; ?></a>
                            <?php
                        } // foreach categorias ?>
                        <strong class="breadcrumb__pag"><?php echo get_the_title($post->ID); ?></strong>
                    </div>
                </div>
                <div class="row flex-column-reverse flex-md-row justify-content-center">
                    <div class="col-md-6">
                        <h1 class="produto__titulo"><?php echo get_the_title($post->ID); ?></h1>
                        <?php
                        $descricao = get_field('descricao', $post->ID);
                        if (!empty($descricao)) { ?>
                            <div class="produto__desc"><?php echo $descricao; ?></div>
                            <?php
                        } // if descricao

                        $galeria = get_field('galeria', $post->ID);
                        $imagem_url_thumbnail = get_template_directory_uri() . '/images/placeholder.png';

                        if (!empty($galeria)) {
                            $imagem_url_thumbnail = $galeria[0]['sizes']['thumbnail'];
                        } // if galeria
                        ?>
                        <button class="add-orcamento-btn" js-adicionar js-codigo="<?php echo $post->ID; ?>" js-link="<?php the_permalink() ?>" js-imagem="<?php echo $imagem_url_thumbnail; ?>" js-titulo="<?php echo get_the_title($post->ID); ?>"><?php svg('icon-carrinho'); ?><span js-adicionado>Incluir no</span><span style="display: none" js-removido>Remover do</span> orçamento</button>
                        <a href="https://api.whatsapp.com/send?phone=5551980423335" target="_blank" class="duvidas-btn"><?php svg('icon-whatsapp'); ?> Envie sua dúvida</a>
                    </div>
                    <!-- Swiper -->

                    <div class="col-md-6">
                        <div class="produto__imagens">
                            <div class="swiper-container produto-slide">
                                <div class="swiper-wrapper">
                                    <?php foreach ($galeria as $imagem) { ?>
                                        <div class="swiper-slide">
                                            <div class="produto__img-box"><a href="<?php echo $imagem['sizes']['large'] ?>" data-fancybox="galeria" class="imagem"><img class="produto__img" src="<?php echo $imagem['sizes']['medium']; ?>" alt="<?php echo get_the_title($post->ID); ?>"></div></a>
                                        </div>
                                    <?php } //foreach $galeria
                                    ?>
                                </div>
                            </div>
                            <div class="swiper-container produto-thumbs">
                                <div class="swiper-wrapper">
                                    <?php foreach ($galeria as $imagem) { ?>
                                        <div class="swiper-slide">
                                            <div class="produto__img-box"><img class="produto__img" src="<?php echo $imagem['sizes']['medium']; ?>" alt="<?php echo get_the_title($post->ID); ?>"></div>
                                        </div>
                                    <?php } //foreach $galeria
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
                $args = array(
                    'post_type' => 'produto',
                    'numberposts' => 3,
                    'post__not_in' => array($post->ID),
                    'orderby' => 'rand',
                );
                $relacionados = get_posts($args);

                if (!empty($relacionados)) { ?>
                    <div class="relacionados">
                        <h2 class="sidebar__titulo">mais produtos</h2>
                        <div class="produtos-grid">
                            <?php
                            foreach ($relacionados as $post) {
                                include '_produto.php';
                            } // foreach relacionados
                            ?>
                        </div>
                        <a href="<?php echo site_url('produtos'); ?>" class="btn-padrao">Ver todos produtos</a>
                    </div>
                    <?php
                } // if !empty relacionados
                ?>
            </main>
        </div>
    </div>
</div>

<?php get_footer(); ?>