<?php get_header(); ?>

<main id="ft_servico" class="pagina">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <h1 class="titulo-padrao"><?php the_title(); ?></h1>
                <p class="legenda"><?php echo get_field('introducao'); ?></p>
                <a href="#ft_bl-contato" js-ancora-suave class="btn-padrao">Solicitar orçamento</a>
                <div class="editor">
                    <?php echo get_field('descricao'); ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="grid-fotos">
                    <?php
                    $galeria = get_field('galeria');
                    foreach ($galeria as $imagem) { ?>
                        <a href="<?php echo $imagem['sizes']['large'] ?>" data-fancybox="galeria" class="imagem"><img src="<?php echo $imagem['sizes']['medium'] ?>" alt="<?php echo $imagem['alt'] ?>"></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include '_bloco-contato.php'; ?>

<section class="servicos-relacionados">
    <div class="container">
        <h2 class="sidebar__titulo">outros serviços</h2>
        <div class="grid-servicos-vertical">
            <?php
            $args = get_args('servico', 4);
            $args['post__not_in'] = array($post->ID);
            $paginacao = listar($args, '_servico.php');
            ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>